/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import io.branch.referral.Branch;
import io.branch.referral.Defines;
import io.branch.referral.SystemObserver;
import java.util.HashMap;
import java.util.Map;

public class BranchPluginSupport {
    private final SystemObserver systemObserver_;
    private final Context context_;

    public static BranchPluginSupport getInstance() {
        Branch b = Branch.getInstance();
        if (b == null) {
            return null;
        }
        return b.getBranchPluginSupport();
    }

    BranchPluginSupport(Context context) {
        this.context_ = context;
        this.systemObserver_ = new SystemObserverInstance();
    }

    public Map<String, Object> deviceDescription() {
        String brandName;
        String localIpAddr;
        String languageCode;
        HashMap<String, Object> deviceDataObj = new HashMap<String, Object>();
        String osName = SystemObserver.getOS(this.context_);
        if (!BranchPluginSupport.isNullOrEmptyOrBlank(osName)) {
            deviceDataObj.put(Defines.Jsonkey.OS.getKey(), osName);
        }
        deviceDataObj.put(Defines.Jsonkey.OSVersionAndroid.getKey(), SystemObserver.getOSVersion());
        SystemObserver.UniqueId hardwareID = this.getHardwareID();
        if (!BranchPluginSupport.isNullOrEmptyOrBlank(hardwareID.getId())) {
            deviceDataObj.put(Defines.Jsonkey.AndroidID.getKey(), hardwareID.getId());
            deviceDataObj.put(Defines.Jsonkey.IsHardwareIDReal.getKey(), hardwareID.isReal());
        } else {
            deviceDataObj.put(Defines.Jsonkey.UnidentifiedDevice.getKey(), true);
        }
        String countryCode = SystemObserver.getISO2CountryCode();
        if (!TextUtils.isEmpty((CharSequence)countryCode)) {
            deviceDataObj.put(Defines.Jsonkey.Country.getKey(), countryCode);
        }
        if (!TextUtils.isEmpty((CharSequence)(languageCode = SystemObserver.getISO2LanguageCode()))) {
            deviceDataObj.put(Defines.Jsonkey.Language.getKey(), languageCode);
        }
        if (!TextUtils.isEmpty((CharSequence)(localIpAddr = SystemObserver.getLocalIPAddress()))) {
            deviceDataObj.put(Defines.Jsonkey.LocalIP.getKey(), localIpAddr);
        }
        if (!BranchPluginSupport.isNullOrEmptyOrBlank(brandName = SystemObserver.getPhoneBrand())) {
            deviceDataObj.put(Defines.Jsonkey.Brand.getKey(), brandName);
        }
        String appVersion = SystemObserver.getAppVersion(this.context_);
        deviceDataObj.put(Defines.Jsonkey.AppVersion.getKey(), appVersion);
        String modelName = SystemObserver.getPhoneModel();
        if (!BranchPluginSupport.isNullOrEmptyOrBlank(modelName)) {
            deviceDataObj.put(Defines.Jsonkey.Model.getKey(), modelName);
        }
        DisplayMetrics displayMetrics = SystemObserver.getScreenDisplay(this.context_);
        deviceDataObj.put(Defines.Jsonkey.ScreenDpi.getKey(), displayMetrics.densityDpi);
        deviceDataObj.put(Defines.Jsonkey.ScreenHeight.getKey(), displayMetrics.heightPixels);
        deviceDataObj.put(Defines.Jsonkey.ScreenWidth.getKey(), displayMetrics.widthPixels);
        return deviceDataObj;
    }

    public SystemObserver.UniqueId getHardwareID() {
        this.getSystemObserver();
        return SystemObserver.getUniqueID(this.context_, Branch.isDeviceIDFetchDisabled());
    }

    SystemObserver getSystemObserver() {
        return this.systemObserver_;
    }

    public static boolean isNullOrEmptyOrBlank(String str) {
        return TextUtils.isEmpty((CharSequence)str) || str.equals("bnc_no_value");
    }

    private class SystemObserverInstance
    extends SystemObserver {
    }
}

