/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

public class BranchError {
    String errorMessage_ = "";
    int errorCode_ = -122;
    public static final int ERR_NO_SESSION = -101;
    public static final int ERR_NO_INTERNET_PERMISSION = -102;
    public static final int ERR_BRANCH_INIT_FAILED = -104;
    public static final int ERR_BRANCH_DUPLICATE_URL = -105;
    public static final int ERR_API_LVL_14_NEEDED = -108;
    public static final int ERR_BRANCH_NOT_INSTANTIATED = -109;
    public static final int ERR_BRANCH_NO_SHARE_OPTION = -110;
    public static final int ERR_BRANCH_REQ_TIMED_OUT = -111;
    public static final int ERR_BRANCH_UNABLE_TO_REACH_SERVERS = -112;
    public static final int ERR_BRANCH_NO_CONNECTIVITY = -113;
    public static final int ERR_BRANCH_KEY_INVALID = -114;
    public static final int ERR_BRANCH_RESOURCE_CONFLICT = -115;
    public static final int ERR_BRANCH_INVALID_REQUEST = -116;
    public static final int ERR_BRANCH_TRACKING_DISABLED = -117;
    public static final int ERR_BRANCH_ALREADY_INITIALIZED = -118;
    public static final int ERR_IMPROPER_REINITIALIZATION = -119;
    public static final int ERR_BRANCH_TASK_TIMEOUT = -120;
    public static final int ERR_NETWORK_ON_MAIN = -121;
    public static final int ERR_OTHER = -122;

    public String getMessage() {
        return this.errorMessage_;
    }

    public int getErrorCode() {
        return this.errorCode_;
    }

    public String toString() {
        return this.getMessage();
    }

    public BranchError(String failMsg, int statusCode) {
        this.errorMessage_ = failMsg + this.initErrorCodeAndGetLocalisedMessage(statusCode);
    }

    private String initErrorCodeAndGetLocalisedMessage(int statusCode) {
        String errMsg;
        if (statusCode == -113) {
            this.errorCode_ = -113;
            errMsg = " Check network connectivity or DNS settings.";
        } else if (statusCode == -114) {
            this.errorCode_ = -114;
            errMsg = " Branch API Error: Please enter your branch_key in your project's manifest file first.";
        } else if (statusCode == -104) {
            this.errorCode_ = -104;
            errMsg = " Did you forget to call init? Make sure you init the session before making Branch calls.";
        } else if (statusCode == -101) {
            this.errorCode_ = -101;
            errMsg = " Unable to initialize Branch. Check network connectivity or that your branch key is valid.";
        } else if (statusCode == -102) {
            this.errorCode_ = -102;
            errMsg = " Please add 'android.permission.INTERNET' in your applications manifest file.";
        } else if (statusCode == -105) {
            this.errorCode_ = -105;
            errMsg = " Unable to create a URL with that alias. If you want to reuse the alias, make sure to submit the same properties for all arguments and that the user is the same owner.";
        } else if (statusCode == -108) {
            this.errorCode_ = -108;
            errMsg = "BranchApp class can be used only with API level 14 or above. Please make sure your minimum API level supported is 14. If you wish to use API level below 14 consider calling getInstance(Context) instead.";
        } else if (statusCode == -109) {
            this.errorCode_ = -109;
            errMsg = "Branch instance is not created. Make  sure your Application class is an instance of BranchLikedApp.";
        } else if (statusCode == -110) {
            this.errorCode_ = -110;
            errMsg = " Unable create share options. Couldn't find applications on device to share the link.";
        } else if (statusCode == -111) {
            this.errorCode_ = -111;
            errMsg = " Request to Branch server timed out. Please check your internet connectivity";
        } else if (statusCode == -117) {
            this.errorCode_ = -117;
            errMsg = " Tracking is disabled. Requested operation cannot be completed when tracking is disabled";
        } else if (statusCode == -118) {
            this.errorCode_ = -118;
            errMsg = " Session initialization already happened. To force a new session, set intent extra, \"branch_force_new_session\", to true.";
        } else if (statusCode >= 500 || statusCode == -112) {
            this.errorCode_ = statusCode;
            errMsg = " Unable to reach the Branch servers, please try again shortly.";
        } else if (statusCode == 409 || statusCode == -115) {
            this.errorCode_ = statusCode;
            errMsg = " A resource with this identifier already exists.";
        } else if (statusCode >= 400 || statusCode == -116) {
            this.errorCode_ = statusCode;
            errMsg = " The request was invalid";
        } else if (statusCode == -119) {
            this.errorCode_ = -119;
            errMsg = "Intra-app linking (i.e. session reinitialization) requires an intent flag, \"branch_force_new_session\".";
        } else if (statusCode == -120) {
            this.errorCode_ = -120;
            errMsg = " Task exceeded timeout.";
        } else {
            this.errorCode_ = -122;
            errMsg = " See exception message or logs for more details. ";
        }
        return errMsg;
    }
}

