/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.util;

import android.content.Context;
import android.text.TextUtils;
import io.branch.indexing.BranchUniversalObject;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerRequestLogEvent;
import io.branch.referral.ServerResponse;
import io.branch.referral.util.AdType;
import io.branch.referral.util.BRANCH_STANDARD_EVENT;
import io.branch.referral.util.CurrencyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchEvent {
    private final String eventName;
    private final boolean isStandardEvent;
    private final HashMap<String, Object> topLevelProperties = new HashMap();
    private final JSONObject standardProperties = new JSONObject();
    private final JSONObject customProperties = new JSONObject();
    private final List<BranchUniversalObject> buoList;

    public BranchEvent(BRANCH_STANDARD_EVENT branchStandardEvent) {
        this(branchStandardEvent.getName());
    }

    public BranchEvent(String eventName) {
        this.eventName = eventName;
        boolean standardEvent = false;
        for (BRANCH_STANDARD_EVENT event : BRANCH_STANDARD_EVENT.values()) {
            if (!eventName.equals(event.getName())) continue;
            standardEvent = true;
            break;
        }
        this.isStandardEvent = standardEvent;
        this.buoList = new ArrayList<BranchUniversalObject>();
    }

    public BranchEvent setCustomerEventAlias(String customerEventAlias) {
        return this.addTopLevelProperty(Defines.Jsonkey.CustomerEventAlias.getKey(), customerEventAlias);
    }

    public BranchEvent setAdType(AdType adType) {
        return this.addStandardProperty(Defines.Jsonkey.AdType.getKey(), adType.getName());
    }

    public BranchEvent setTransactionID(String transactionID) {
        return this.addStandardProperty(Defines.Jsonkey.TransactionID.getKey(), transactionID);
    }

    public BranchEvent setCurrency(CurrencyType currency) {
        return this.addStandardProperty(Defines.Jsonkey.Currency.getKey(), currency.toString());
    }

    public BranchEvent setRevenue(double revenue) {
        return this.addStandardProperty(Defines.Jsonkey.Revenue.getKey(), revenue);
    }

    public BranchEvent setShipping(double shipping) {
        return this.addStandardProperty(Defines.Jsonkey.Shipping.getKey(), shipping);
    }

    public BranchEvent setTax(double tax) {
        return this.addStandardProperty(Defines.Jsonkey.Tax.getKey(), tax);
    }

    public BranchEvent setCoupon(String coupon) {
        return this.addStandardProperty(Defines.Jsonkey.Coupon.getKey(), coupon);
    }

    public BranchEvent setAffiliation(String affiliation) {
        return this.addStandardProperty(Defines.Jsonkey.Affiliation.getKey(), affiliation);
    }

    public BranchEvent setDescription(String description) {
        return this.addStandardProperty(Defines.Jsonkey.Description.getKey(), description);
    }

    public BranchEvent setSearchQuery(String searchQuery) {
        return this.addStandardProperty(Defines.Jsonkey.SearchQuery.getKey(), searchQuery);
    }

    private BranchEvent addStandardProperty(String propertyName, Object propertyValue) {
        if (propertyValue != null) {
            try {
                this.standardProperties.put(propertyName, propertyValue);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.standardProperties.remove(propertyName);
        }
        return this;
    }

    private BranchEvent addTopLevelProperty(String propertyName, Object propertyValue) {
        if (!this.topLevelProperties.containsKey(propertyName)) {
            this.topLevelProperties.put(propertyName, propertyValue);
        } else {
            this.topLevelProperties.remove(propertyName);
        }
        return this;
    }

    public BranchEvent addCustomDataProperty(String propertyName, String propertyValue) {
        try {
            this.customProperties.put(propertyName, (Object)propertyValue);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public BranchEvent addContentItems(BranchUniversalObject ... contentItems) {
        Collections.addAll(this.buoList, contentItems);
        return this;
    }

    public BranchEvent addContentItems(List<BranchUniversalObject> contentItems) {
        this.buoList.addAll(contentItems);
        return this;
    }

    public String getEventName() {
        return this.eventName;
    }

    public boolean logEvent(Context context) {
        return this.logEvent(context, null);
    }

    public boolean logEvent(Context context, final BranchLogEventCallback callback) {
        Defines.RequestPath reqPath;
        boolean isReqQueued = false;
        Defines.RequestPath requestPath = reqPath = this.isStandardEvent ? Defines.RequestPath.TrackStandardEvent : Defines.RequestPath.TrackCustomEvent;
        if (Branch.getInstance() != null) {
            ServerRequestLogEvent req = new ServerRequestLogEvent(context, reqPath, this.eventName, this.topLevelProperties, this.standardProperties, this.customProperties, this.buoList){

                @Override
                public void onRequestSucceeded(ServerResponse response, Branch branch) {
                    if (callback != null) {
                        callback.onSuccess(response.getStatusCode());
                    }
                }

                @Override
                public void handleFailure(int statusCode, String causeMsg) {
                    if (callback != null) {
                        Exception e = new Exception("Failed logEvent server request: " + statusCode + causeMsg);
                        callback.onFailure(e);
                    }
                }
            };
            BranchLogger.v("Preparing V2 event, user agent is " + Branch._userAgentString);
            if (TextUtils.isEmpty((CharSequence)Branch._userAgentString)) {
                BranchLogger.v("handleNewRequest adding process wait lock USER_AGENT_STRING_LOCK");
                req.addProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.USER_AGENT_STRING_LOCK);
            }
            Branch.getInstance().requestQueue_.handleNewRequest(req);
            isReqQueued = true;
        } else if (callback != null) {
            Exception e = new Exception("Failed logEvent server request: The Branch instance was not available");
            callback.onFailure(e);
        }
        return isReqQueued;
    }

    public static interface BranchLogEventCallback {
        public void onSuccess(int var1);

        public void onFailure(Exception var1);
    }
}

