/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import io.branch.indexing.BranchUniversalObject;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.util.BRANCH_STANDARD_EVENT;
import io.branch.referral.util.BranchEvent;
import io.branch.referral.util.LinkProperties;
import io.branch.referral.util.SharingUtil;
import java.io.PrintWriter;
import java.io.StringWriter;

public class NativeShareLinkManager {
    private static volatile NativeShareLinkManager INSTANCE = null;
    Branch.BranchNativeLinkShareListener nativeLinkShareListenerCallback_;

    private NativeShareLinkManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NativeShareLinkManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<NativeShareLinkManager> clazz = NativeShareLinkManager.class;
        synchronized (NativeShareLinkManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new NativeShareLinkManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @RequiresApi(api=22)
    void shareLink(final @NonNull Activity activity, @NonNull BranchUniversalObject buo, @NonNull LinkProperties linkProperties, final @Nullable Branch.BranchNativeLinkShareListener callback, final String title, final String subject) {
        this.nativeLinkShareListenerCallback_ = new NativeLinkShareListenerWrapper(callback, linkProperties, buo);
        try {
            buo.generateShortUrl((Context)activity, linkProperties, new Branch.BranchLinkCreateListener(){

                @Override
                public void onLinkCreate(String url, BranchError error) {
                    if (error == null) {
                        SharingUtil.share(url, title, subject, activity);
                    } else {
                        if (callback != null) {
                            callback.onLinkShareResponse(url, error);
                        } else {
                            BranchLogger.v("Unable to share link " + error.getMessage());
                        }
                        if (error.getErrorCode() == -113 || error.getErrorCode() == -117) {
                            SharingUtil.share(url, title, subject, activity);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            BranchLogger.e(errors.toString());
            if (this.nativeLinkShareListenerCallback_ != null) {
                this.nativeLinkShareListenerCallback_.onLinkShareResponse(null, new BranchError("Trouble sharing link", -110));
            }
            BranchLogger.v("Unable to share link. " + e.getMessage());
        }
    }

    public Branch.BranchNativeLinkShareListener getLinkShareListenerCallback() {
        return this.nativeLinkShareListenerCallback_;
    }

    private class NativeLinkShareListenerWrapper
    implements Branch.BranchNativeLinkShareListener {
        private final Branch.BranchNativeLinkShareListener branchNativeLinkShareListener_;
        private final BranchUniversalObject buo_;
        private String channelSelected_;

        NativeLinkShareListenerWrapper(Branch.BranchNativeLinkShareListener branchNativeLinkShareListener, LinkProperties linkProperties, BranchUniversalObject buo) {
            this.branchNativeLinkShareListener_ = branchNativeLinkShareListener;
            this.buo_ = buo;
            this.channelSelected_ = "";
        }

        @Override
        public void onLinkShareResponse(String sharedLink, BranchError error) {
            BranchEvent shareEvent = new BranchEvent(BRANCH_STANDARD_EVENT.SHARE);
            if (error == null) {
                shareEvent.addCustomDataProperty(Defines.Jsonkey.SharedLink.getKey(), sharedLink);
                shareEvent.addCustomDataProperty(Defines.Jsonkey.SharedChannel.getKey(), this.channelSelected_);
                shareEvent.addContentItems(this.buo_);
            } else {
                shareEvent.addCustomDataProperty(Defines.Jsonkey.ShareError.getKey(), error.getMessage());
            }
            shareEvent.logEvent(Branch.getInstance().getApplicationContext());
            if (this.branchNativeLinkShareListener_ != null) {
                this.branchNativeLinkShareListener_.onLinkShareResponse(sharedLink, error);
            }
        }

        @Override
        public void onChannelSelected(String channelName) {
            this.channelSelected_ = channelName;
            if (this.branchNativeLinkShareListener_ != null) {
                this.branchNativeLinkShareListener_.onChannelSelected(channelName);
            }
        }
    }
}

