/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.BranchShortLinkBuilder;
import io.branch.referral.BranchUtil;
import io.branch.referral.SharingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class BranchShareSheetBuilder {
    private final Activity activity_;
    private String shareMsg_;
    private String shareSub_;
    private Branch.BranchLinkShareListener callback_;
    private Branch.IChannelProperties channelPropertiesCallback_;
    private ArrayList<SharingHelper.SHARE_WITH> preferredOptions_;
    private String defaultURL_;
    private Drawable moreOptionIcon_;
    private String moreOptionText_;
    private Drawable copyUrlIcon_;
    private String copyURlText_;
    private String urlCopiedMessage_;
    private int styleResourceID_;
    private boolean setFullWidthStyle_;
    private int dialogThemeResourceID_;
    private int dividerHeight_ = -1;
    private String sharingTitle_ = null;
    private View sharingTitleView_ = null;
    private int iconSize_ = 50;
    private BranchShortLinkBuilder shortLinkBuilder_;
    private List<String> includeInShareSheet = new ArrayList<String>();
    private List<String> excludeFromShareSheet = new ArrayList<String>();

    public BranchShareSheetBuilder(Activity activity, JSONObject parameters) {
        this.activity_ = activity;
        this.shortLinkBuilder_ = new BranchShortLinkBuilder((Context)activity);
        try {
            Iterator keys = parameters.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.shortLinkBuilder_.addParameters(key, parameters.get(key));
            }
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
        this.shareMsg_ = "";
        this.callback_ = null;
        this.channelPropertiesCallback_ = null;
        this.preferredOptions_ = new ArrayList();
        this.defaultURL_ = null;
        this.moreOptionIcon_ = BranchUtil.getDrawable(activity.getApplicationContext(), 17301573);
        this.moreOptionText_ = "More...";
        this.copyUrlIcon_ = BranchUtil.getDrawable(activity.getApplicationContext(), 17301582);
        this.copyURlText_ = "Copy link";
        this.urlCopiedMessage_ = "Copied link to clipboard!";
        if (Branch.getInstance().getDeviceInfo().isTV()) {
            this.excludeFromShareSheet("com.google.android.tv.frameworkpackagestubs");
        }
    }

    public BranchShareSheetBuilder(Activity activity, BranchShortLinkBuilder shortLinkBuilder) {
        this(activity, new JSONObject());
        this.shortLinkBuilder_ = shortLinkBuilder;
    }

    public BranchShareSheetBuilder setMessage(String message) {
        this.shareMsg_ = message;
        return this;
    }

    public BranchShareSheetBuilder setSubject(String subject) {
        this.shareSub_ = subject;
        return this;
    }

    public BranchShareSheetBuilder addTag(String tag) {
        this.shortLinkBuilder_.addTag(tag);
        return this;
    }

    public BranchShareSheetBuilder addTags(ArrayList<String> tags) {
        this.shortLinkBuilder_.addTags(tags);
        return this;
    }

    public BranchShareSheetBuilder setFeature(String feature) {
        this.shortLinkBuilder_.setFeature(feature);
        return this;
    }

    public BranchShareSheetBuilder setStage(String stage) {
        this.shortLinkBuilder_.setStage(stage);
        return this;
    }

    public BranchShareSheetBuilder setCallback(Branch.BranchLinkShareListener callback) {
        this.callback_ = callback;
        return this;
    }

    public BranchShareSheetBuilder setChannelProperties(Branch.IChannelProperties channelPropertiesCallback) {
        this.channelPropertiesCallback_ = channelPropertiesCallback;
        return this;
    }

    public BranchShareSheetBuilder addPreferredSharingOption(SharingHelper.SHARE_WITH preferredOption) {
        this.preferredOptions_.add(preferredOption);
        return this;
    }

    public BranchShareSheetBuilder addPreferredSharingOptions(ArrayList<SharingHelper.SHARE_WITH> preferredOptions) {
        this.preferredOptions_.addAll(preferredOptions);
        return this;
    }

    public BranchShareSheetBuilder addParam(String key, String value) {
        try {
            this.shortLinkBuilder_.addParameters(key, value);
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
        return this;
    }

    public BranchShareSheetBuilder setDefaultURL(String url) {
        this.defaultURL_ = url;
        return this;
    }

    public BranchShareSheetBuilder setMoreOptionStyle(Drawable icon, String label) {
        this.moreOptionIcon_ = icon;
        this.moreOptionText_ = label;
        return this;
    }

    public BranchShareSheetBuilder setMoreOptionStyle(int drawableIconID, int stringLabelID) {
        this.moreOptionIcon_ = BranchUtil.getDrawable(this.activity_.getApplicationContext(), drawableIconID);
        this.moreOptionText_ = this.activity_.getResources().getString(stringLabelID);
        return this;
    }

    public BranchShareSheetBuilder setCopyUrlStyle(Drawable icon, String label, String message) {
        this.copyUrlIcon_ = icon;
        this.copyURlText_ = label;
        this.urlCopiedMessage_ = message;
        return this;
    }

    public BranchShareSheetBuilder setCopyUrlStyle(int drawableIconID, int stringLabelID, int stringMessageID) {
        this.copyUrlIcon_ = BranchUtil.getDrawable(this.activity_.getApplicationContext(), drawableIconID);
        this.copyURlText_ = this.activity_.getResources().getString(stringLabelID);
        this.urlCopiedMessage_ = this.activity_.getResources().getString(stringMessageID);
        return this;
    }

    public BranchShareSheetBuilder setAlias(String alias) {
        this.shortLinkBuilder_.setAlias(alias);
        return this;
    }

    public BranchShareSheetBuilder setMatchDuration(int matchDuration) {
        this.shortLinkBuilder_.setDuration(matchDuration);
        return this;
    }

    public BranchShareSheetBuilder setAsFullWidthStyle(boolean setFullWidthStyle) {
        this.setFullWidthStyle_ = setFullWidthStyle;
        return this;
    }

    public BranchShareSheetBuilder setDialogThemeResourceID(@StyleRes int styleResourceID) {
        this.dialogThemeResourceID_ = styleResourceID;
        return this;
    }

    public BranchShareSheetBuilder setDividerHeight(int height) {
        this.dividerHeight_ = height;
        return this;
    }

    public BranchShareSheetBuilder setSharingTitle(String title) {
        this.sharingTitle_ = title;
        return this;
    }

    public BranchShareSheetBuilder setSharingTitle(View titleView) {
        this.sharingTitleView_ = titleView;
        return this;
    }

    public BranchShareSheetBuilder setIconSize(int iconSize) {
        this.iconSize_ = iconSize;
        return this;
    }

    public BranchShareSheetBuilder excludeFromShareSheet(@NonNull String packageName) {
        this.excludeFromShareSheet.add(packageName);
        return this;
    }

    public BranchShareSheetBuilder excludeFromShareSheet(@NonNull String[] packageName) {
        this.excludeFromShareSheet.addAll(Arrays.asList(packageName));
        return this;
    }

    public BranchShareSheetBuilder excludeFromShareSheet(@NonNull List<String> packageNames) {
        this.excludeFromShareSheet.addAll(packageNames);
        return this;
    }

    public BranchShareSheetBuilder includeInShareSheet(@NonNull String packageName) {
        this.includeInShareSheet.add(packageName);
        return this;
    }

    public BranchShareSheetBuilder includeInShareSheet(@NonNull String[] packageName) {
        this.includeInShareSheet.addAll(Arrays.asList(packageName));
        return this;
    }

    public BranchShareSheetBuilder includeInShareSheet(@NonNull List<String> packageNames) {
        this.includeInShareSheet.addAll(packageNames);
        return this;
    }

    public void setStyleResourceID(@StyleRes int resourceID) {
        this.styleResourceID_ = resourceID;
    }

    public void setShortLinkBuilderInternal(BranchShortLinkBuilder shortLinkBuilder) {
        this.shortLinkBuilder_ = shortLinkBuilder;
    }

    public void shareLink() {
        Branch.getInstance().shareLink(this);
    }

    public Activity getActivity() {
        return this.activity_;
    }

    public ArrayList<SharingHelper.SHARE_WITH> getPreferredOptions() {
        return this.preferredOptions_;
    }

    List<String> getExcludedFromShareSheet() {
        return this.excludeFromShareSheet;
    }

    List<String> getIncludedInShareSheet() {
        return this.includeInShareSheet;
    }

    @Deprecated
    public Branch getBranch() {
        return Branch.getInstance();
    }

    public String getShareMsg() {
        return this.shareMsg_;
    }

    public String getShareSub() {
        return this.shareSub_;
    }

    public Branch.BranchLinkShareListener getCallback() {
        return this.callback_;
    }

    public Branch.IChannelProperties getChannelPropertiesCallback() {
        return this.channelPropertiesCallback_;
    }

    public String getDefaultURL() {
        return this.defaultURL_;
    }

    public Drawable getMoreOptionIcon() {
        return this.moreOptionIcon_;
    }

    public String getMoreOptionText() {
        return this.moreOptionText_;
    }

    public Drawable getCopyUrlIcon() {
        return this.copyUrlIcon_;
    }

    public String getCopyURlText() {
        return this.copyURlText_;
    }

    public String getUrlCopiedMessage() {
        return this.urlCopiedMessage_;
    }

    public BranchShortLinkBuilder getShortLinkBuilder() {
        return this.shortLinkBuilder_;
    }

    public boolean getIsFullWidthStyle() {
        return this.setFullWidthStyle_;
    }

    public int getDialogThemeResourceID() {
        return this.dialogThemeResourceID_;
    }

    public int getDividerHeight() {
        return this.dividerHeight_;
    }

    public String getSharingTitle() {
        return this.sharingTitle_;
    }

    public View getSharingTitleView() {
        return this.sharingTitleView_;
    }

    public int getStyleResourceID() {
        return this.styleResourceID_;
    }

    public int getIconSize() {
        return this.iconSize_;
    }
}

