/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.Branch;
import io.branch.referral.Defines;
import io.branch.referral.SystemObserver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchQRCodeCache {
    private final SystemObserver systemObserver_;
    private final Context context_;
    public ConcurrentHashMap<JSONObject, byte[]> cache = new ConcurrentHashMap();

    public static BranchQRCodeCache getInstance() {
        Branch b = Branch.getInstance();
        if (b == null) {
            return null;
        }
        return b.getBranchQRCodeCache();
    }

    BranchQRCodeCache(Context context) {
        this.context_ = context;
        this.systemObserver_ = new SystemObserverInstance();
    }

    SystemObserver getSystemObserver() {
        return this.systemObserver_;
    }

    public void addQRCodeToCache(JSONObject parameters, byte[] qrCodeData) {
        this.cache.clear();
        try {
            parameters.getJSONObject("data").remove(Defines.Jsonkey.CreationTimestamp.getKey());
            this.cache.put(parameters, qrCodeData);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public byte[] checkQRCodeCache(JSONObject parameters) {
        if (this.cache.isEmpty()) {
            return null;
        }
        try {
            parameters.getJSONObject("data").remove(Defines.Jsonkey.CreationTimestamp.getKey());
            JSONObject cacheParam = (JSONObject)this.cache.keySet().iterator().next();
            if (BranchQRCodeCache.areEqual(parameters, cacheParam)) {
                return this.cache.get(cacheParam);
            }
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean areEqual(Object ob1, Object ob2) throws JSONException {
        Object obj1Converted = BranchQRCodeCache.convertJsonElement(ob1);
        Object obj2Converted = BranchQRCodeCache.convertJsonElement(ob2);
        return obj1Converted.equals(obj2Converted);
    }

    private static Object convertJsonElement(Object elem) throws JSONException {
        if (elem instanceof JSONObject) {
            JSONObject obj = (JSONObject)elem;
            Iterator keys = obj.keys();
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                jsonMap.put(key, BranchQRCodeCache.convertJsonElement(obj.get(key)));
            }
            return jsonMap;
        }
        if (elem instanceof JSONArray) {
            JSONArray arr = (JSONArray)elem;
            HashSet<Object> jsonSet = new HashSet<Object>();
            for (int i = 0; i < arr.length(); ++i) {
                jsonSet.add(BranchQRCodeCache.convertJsonElement(arr.get(i)));
            }
            return jsonSet;
        }
        return elem;
    }

    private class SystemObserverInstance
    extends SystemObserver {
    }
}

