/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.text.TextUtils;
import io.branch.referral.BranchLogger;
import io.branch.referral.BranchPreinstall;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;

public class AppStoreReferrer {
    private static String installID_ = "bnc_no_value";

    public static void processReferrerInfo(Context context, String rawReferrerString, long referrerClickTS, long installClickTS, String store, Boolean isClickThrough) {
        PrefHelper prefHelper = PrefHelper.getInstance(context);
        if (!TextUtils.isEmpty((CharSequence)store)) {
            prefHelper.setAppStoreSource(store);
            if (store.equals(Defines.Jsonkey.Meta_Install_Referrer.getKey())) {
                prefHelper.setIsMetaClickThrough(isClickThrough);
            }
        }
        if (referrerClickTS > 0L) {
            prefHelper.setLong("bnc_referrer_click_ts", referrerClickTS);
        }
        if (installClickTS > 0L) {
            prefHelper.setLong("bnc_install_begin_ts", installClickTS);
        }
        if (rawReferrerString != null) {
            try {
                rawReferrerString = URLDecoder.decode(rawReferrerString, "UTF-8");
                HashMap<String, String> referrerMap = new HashMap<String, String>();
                String[] referralParams = rawReferrerString.split("&");
                prefHelper.setAppStoreReferrer(rawReferrerString);
                for (String referrerParam : referralParams) {
                    String[] keyValue;
                    if (TextUtils.isEmpty((CharSequence)referrerParam)) continue;
                    String splitter = "=";
                    if (!referrerParam.contains("=") && referrerParam.contains("-")) {
                        splitter = "-";
                    }
                    if ((keyValue = referrerParam.split(splitter)).length <= 1) continue;
                    referrerMap.put(URLDecoder.decode(keyValue[0], "UTF-8"), URLDecoder.decode(keyValue[1], "UTF-8"));
                }
                if (referrerMap.containsKey(Defines.Jsonkey.LinkClickID.getKey())) {
                    installID_ = (String)referrerMap.get(Defines.Jsonkey.LinkClickID.getKey());
                    prefHelper.setLinkClickIdentifier(installID_);
                }
                if (referrerMap.containsKey(Defines.Jsonkey.IsFullAppConv.getKey()) && referrerMap.containsKey(Defines.Jsonkey.ReferringLink.getKey())) {
                    prefHelper.setIsFullAppConversion(Boolean.parseBoolean((String)referrerMap.get(Defines.Jsonkey.IsFullAppConv.getKey())));
                    prefHelper.setAppLink(referrerMap.get(Defines.Jsonkey.ReferringLink.getKey()));
                }
                if (referrerMap.containsKey(Defines.Jsonkey.GoogleSearchInstallReferrer.getKey())) {
                    prefHelper.setGoogleSearchInstallIdentifier((String)referrerMap.get(Defines.Jsonkey.GoogleSearchInstallReferrer.getKey()));
                }
                if (referrerMap.containsValue(Defines.Jsonkey.PlayAutoInstalls.getKey())) {
                    BranchPreinstall.setBranchPreInstallGoogleReferrer(context, referrerMap);
                }
            }
            catch (UnsupportedEncodingException e) {
                BranchLogger.w("Caught UnsupportedEncodingException " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                BranchLogger.w("Caught IllegalArgumentException " + e.getMessage());
            }
        }
    }

    public static String getInstallationID() {
        return installID_;
    }
}

