/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.display.DisplayManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.huawei.hms.ads.identifier.AdvertisingIdClient;
import io.branch.coroutines.AdvertisingIdsKt;
import io.branch.coroutines.InstallReferrersKt;
import io.branch.data.InstallReferrerResult;
import io.branch.referral.AppStoreReferrer;
import io.branch.referral.BranchLogger;
import io.branch.referral.DeviceInfo;
import io.branch.referral.PrefHelper;
import io.branch.referral.util.DependencyUtilsKt;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Pair;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;

abstract class SystemObserver {
    static final String BLANK = "bnc_no_value";
    static final String UUID_EMPTY = "00000000-0000-0000-0000-000000000000";
    private String GAIDString_ = null;
    private int LATVal_ = 0;
    private String AIDInitializationSessionID_;

    SystemObserver() {
    }

    static UniqueId getUniqueID(Context context, boolean debug) {
        return new UniqueId(context, debug);
    }

    static String getAnonID(Context context) {
        String anonID = PrefHelper.getInstance(context).getAnonID();
        if (TextUtils.isEmpty((CharSequence)anonID) || anonID.equals(BLANK)) {
            anonID = UUID.randomUUID().toString();
            PrefHelper.getInstance(context).setAnonID(anonID);
        }
        return anonID;
    }

    static String getPackageName(Context context) {
        String packageName = "";
        if (context != null) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                packageName = packageInfo.packageName;
            }
            catch (Exception e) {
                BranchLogger.e("Caught Exception, error obtaining PackageName " + e.getMessage());
            }
        }
        return packageName;
    }

    static String getAppVersion(Context context) {
        String appVersion = "";
        if (context != null) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                appVersion = packageInfo.versionName;
            }
            catch (Exception e) {
                BranchLogger.e("Caught Exception, error obtaining AppVersion " + e.getMessage());
            }
        }
        return TextUtils.isEmpty((CharSequence)appVersion) ? BLANK : appVersion;
    }

    static long getFirstInstallTime(Context context) {
        long firstTime = 0L;
        if (context != null) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                firstTime = packageInfo.firstInstallTime;
            }
            catch (Exception e) {
                BranchLogger.e("Caught Exception, error obtaining FirstInstallTime " + e.getMessage());
            }
        }
        return firstTime;
    }

    static boolean isPackageInstalled(Context context) {
        boolean isInstalled = false;
        if (context != null) {
            try {
                PackageManager packageManager = context.getPackageManager();
                Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                if (intent == null) {
                    return false;
                }
                List list = packageManager.queryIntentActivities(intent, 65536);
                isInstalled = !list.isEmpty();
            }
            catch (Exception e) {
                BranchLogger.e("Caught Exception, error obtaining PackageInfo " + e.getMessage());
            }
        }
        return isInstalled;
    }

    static long getLastUpdateTime(Context context) {
        long lastTime = 0L;
        if (context != null) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                lastTime = packageInfo.lastUpdateTime;
            }
            catch (Exception e) {
                BranchLogger.e("Caught Exception, error obtaining LastUpdateTime " + e.getMessage());
            }
        }
        return lastTime;
    }

    static String getPhoneBrand() {
        return Build.MANUFACTURER;
    }

    static boolean isHuaweiDevice() {
        return SystemObserver.getPhoneBrand().equalsIgnoreCase("huawei");
    }

    static String getPhoneModel() {
        return Build.MODEL;
    }

    static String getISO2CountryCode() {
        return Locale.getDefault().getCountry();
    }

    static String getISO2LanguageCode() {
        return Locale.getDefault().getLanguage();
    }

    static boolean isFireOSDevice() {
        return SystemObserver.getPhoneBrand().equalsIgnoreCase("amazon");
    }

    static boolean isHuaweiMobileServicesAvailable(@NonNull Context context) {
        return SystemObserver.isHuaweiDevice() && !SystemObserver.isGooglePlayServicesAvailable(context);
    }

    static boolean isGooglePlayServicesAvailable(@NonNull Context context) {
        try {
            Class<?> GoogleApiAvailability = Class.forName("com.google.android.gms.common.GoogleApiAvailability");
            Method GoogleApiAvailability_getInstance = GoogleApiAvailability.getDeclaredMethod("getInstance", new Class[0]);
            Object GoogleApiAvailabilityInstance = GoogleApiAvailability_getInstance.invoke(null, new Object[0]);
            Method GoogleisPlayServicesAvailable = GoogleApiAvailability.getDeclaredMethod("isGooglePlayServicesAvailable", Context.class);
            Object result = GoogleisPlayServicesAvailable.invoke(GoogleApiAvailabilityInstance, context);
            return result instanceof Integer && (Integer)result == 0;
        }
        catch (Exception e) {
            BranchLogger.e("Caught Exception " + e.getMessage());
            return false;
        }
    }

    static String getOS(Context context) {
        if (SystemObserver.isFireOSDevice()) {
            if (context == null) {
                return SystemObserver.getPhoneModel().contains("AFT") ? "AMAZON_FIRE_TV" : "AMAZON_FIRE";
            }
            if (context.getPackageManager().hasSystemFeature("amazon.hardware.fire_tv")) {
                return "AMAZON_FIRE_TV";
            }
            return "AMAZON_FIRE";
        }
        return "Android";
    }

    static int getAPILevel() {
        return Build.VERSION.SDK_INT;
    }

    static String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    static String getCPUType() {
        return System.getProperty("os.arch");
    }

    static String getDeviceBuildId() {
        return Build.DISPLAY;
    }

    static String getLocale() {
        return Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
    }

    static String getConnectionType(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager connManager;
        if (context != null && 0 == context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") && (connManager = (ConnectivityManager)context.getSystemService("connectivity")) != null && (networkInfo = connManager.getActiveNetworkInfo()) != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                return "wifi";
            }
            return "mobile";
        }
        return null;
    }

    static String getCarrier(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm == null) {
            return null;
        }
        String carrier = tm.getNetworkOperatorName();
        return TextUtils.isEmpty((CharSequence)carrier) ? null : carrier;
    }

    static DisplayMetrics getScreenDisplay(Context context) {
        Display display = null;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        if (context != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
                if (displayManager != null) {
                    display = displayManager.getDisplay(0);
                }
            } else {
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                if (windowManager != null) {
                    display = windowManager.getDefaultDisplay();
                }
            }
        }
        if (display != null) {
            display.getMetrics(displayMetrics);
        }
        return displayMetrics;
    }

    static boolean getWifiConnected(Context context) {
        return "wifi".equalsIgnoreCase(SystemObserver.getConnectionType(context));
    }

    public void fetchAdId(Context context, AdsParamsFetchEvents callback) {
        if (SystemObserver.isFireOSDevice()) {
            this.setFireAdId(context, callback);
        } else if (SystemObserver.isHuaweiMobileServicesAvailable(context)) {
            this.fetchHuaweiAdId(context, callback);
        } else {
            this.fetchGoogleAdId(context, callback);
        }
    }

    private void fetchHuaweiAdId(Context context, final AdsParamsFetchEvents callback) {
        if (DependencyUtilsKt.classExists("com.huawei.hms.ads.identifier.AdvertisingIdClient")) {
            AdvertisingIdsKt.getHuaweiAdvertisingInfoObject(context, (Continuation<? super AdvertisingIdClient.Info>)new Continuation<AdvertisingIdClient.Info>(){

                @NonNull
                public CoroutineContext getContext() {
                    return EmptyCoroutineContext.INSTANCE;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resumeWith(Object o) {
                    try {
                        if (o != null) {
                            AdvertisingIdClient.Info info = (AdvertisingIdClient.Info)o;
                            boolean lat = info.isLimitAdTrackingEnabled();
                            String aid = null;
                            if (!lat) {
                                aid = info.getId();
                            }
                            SystemObserver.this.setLAT(lat ? 1 : 0);
                            SystemObserver.this.setGAID(aid);
                        }
                    }
                    catch (Exception e) {
                        BranchLogger.e("Error in continuation: " + e);
                    }
                    finally {
                        if (callback != null) {
                            callback.onAdsParamsFetchFinished();
                        }
                    }
                }
            });
        } else {
            if (callback != null) {
                callback.onAdsParamsFetchFinished();
            }
            BranchLogger.v("Huawei advertising service not found. If not expected, import com.huawei.hms.ads.identifier.AdvertisingIdClient into your gradle dependencies");
        }
    }

    private void fetchGoogleAdId(Context context, final AdsParamsFetchEvents callback) {
        if (DependencyUtilsKt.classExists("com.google.android.gms.ads.identifier.AdvertisingIdClient")) {
            AdvertisingIdsKt.getGoogleAdvertisingInfoObject(context, (Continuation<? super AdvertisingIdClient.Info>)new Continuation<AdvertisingIdClient.Info>(){

                @NonNull
                public CoroutineContext getContext() {
                    return EmptyCoroutineContext.INSTANCE;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resumeWith(Object o) {
                    try {
                        if (o != null) {
                            AdvertisingIdClient.Info info = (AdvertisingIdClient.Info)o;
                            boolean lat = info.isLimitAdTrackingEnabled();
                            String aid = null;
                            if (!lat) {
                                aid = info.getId();
                            }
                            SystemObserver.this.setLAT(lat ? 1 : 0);
                            SystemObserver.this.setGAID(aid);
                        }
                    }
                    catch (Exception e) {
                        BranchLogger.e("Error in continuation: " + e);
                    }
                    finally {
                        if (callback != null) {
                            callback.onAdsParamsFetchFinished();
                        }
                    }
                }
            });
        } else {
            if (callback != null) {
                callback.onAdsParamsFetchFinished();
            }
            BranchLogger.v("Play Store advertising service not found. If not expected, import com.google.android.gms.ads.identifier.AdvertisingIdClient into your gradle dependencies");
        }
    }

    private void setFireAdId(Context context, final AdsParamsFetchEvents callback) {
        BranchLogger.v("setFireAdId");
        AdvertisingIdsKt.getAmazonFireAdvertisingInfoObject(context, (Continuation<? super Pair<Integer, String>>)new Continuation<Pair<? extends Integer, ? extends String>>(){

            @NonNull
            public CoroutineContext getContext() {
                return EmptyCoroutineContext.INSTANCE;
            }

            public void resumeWith(@NonNull Object o) {
                try {
                    if (o != null) {
                        Pair info = (Pair)o;
                        SystemObserver.this.setLAT((Integer)info.component1());
                        if ((Integer)info.component1() == 0) {
                            SystemObserver.this.setGAID((String)info.component2());
                        } else {
                            SystemObserver.this.setGAID((String)info.component2());
                        }
                    }
                }
                catch (Exception e) {
                    BranchLogger.e("Error in continuation: " + e);
                }
                finally {
                    if (callback != null) {
                        callback.onAdsParamsFetchFinished();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchInstallReferrer(final Context context_, InstallReferrerFetchEvents callback) {
        try {
            InstallReferrersKt.fetchLatestInstallReferrer(context_, (Continuation<? super InstallReferrerResult>)new Continuation<InstallReferrerResult>(){

                @NonNull
                public CoroutineContext getContext() {
                    return EmptyCoroutineContext.INSTANCE;
                }

                public void resumeWith(@NonNull Object o) {
                    if (o != null) {
                        InstallReferrerResult latestReferrer = (InstallReferrerResult)o;
                        AppStoreReferrer.processReferrerInfo(context_, latestReferrer.getLatestRawReferrer(), latestReferrer.getLatestClickTimestamp(), latestReferrer.getLatestInstallTimestamp(), latestReferrer.getAppStore(), latestReferrer.isClickThrough());
                    }
                }
            });
        }
        catch (Exception e) {
            BranchLogger.e("Caught Exception " + e.getMessage());
        }
        finally {
            if (callback != null) {
                callback.onInstallReferrersFinished();
            }
        }
    }

    static String getLocalIPAddress() {
        String ipAddress = "";
        try {
            ArrayList<NetworkInterface> netInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            block2: for (NetworkInterface netInterface : netInterfaces) {
                ArrayList<InetAddress> addresses = Collections.list(netInterface.getInetAddresses());
                for (InetAddress address : addresses) {
                    String ip;
                    boolean isIPv4;
                    if (address.isLoopbackAddress() || !(isIPv4 = (ip = address.getHostAddress()).indexOf(58) < 0)) continue;
                    ipAddress = ip;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            BranchLogger.e("Caught Exception " + e.getMessage());
        }
        return ipAddress;
    }

    static String getUIMode(Context context) {
        String mode = "UI_MODE_TYPE_UNDEFINED";
        UiModeManager modeManager = null;
        try {
            if (context != null) {
                modeManager = (UiModeManager)context.getSystemService("uimode");
            }
            if (modeManager != null) {
                switch (modeManager.getCurrentModeType()) {
                    case 1: {
                        mode = "UI_MODE_TYPE_NORMAL";
                        break;
                    }
                    case 2: {
                        mode = "UI_MODE_TYPE_DESK";
                        break;
                    }
                    case 3: {
                        mode = "UI_MODE_TYPE_CAR";
                        break;
                    }
                    case 4: {
                        mode = "UI_MODE_TYPE_TELEVISION";
                        break;
                    }
                    case 5: {
                        mode = "UI_MODE_TYPE_APPLIANCE";
                        break;
                    }
                    case 6: {
                        mode = "UI_MODE_TYPE_WATCH";
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            BranchLogger.e("Caught Exception " + e.getMessage());
        }
        return mode;
    }

    String getAID() {
        return this.GAIDString_;
    }

    int getLATVal() {
        return this.LATVal_;
    }

    void setGAID(String gaid) {
        this.GAIDString_ = gaid;
    }

    void setLAT(int lat) {
        this.LATVal_ = lat;
    }

    static class UniqueId {
        private String uniqueId;
        private boolean isRealId;

        @SuppressLint(value={"HardwareIds"})
        UniqueId(Context context, boolean isDebug) {
            boolean aidIsValid;
            this.isRealId = !isDebug;
            this.uniqueId = SystemObserver.BLANK;
            String androidID = null;
            boolean bl = aidIsValid = !TextUtils.isEmpty((CharSequence)DeviceInfo.getInstance().getSystemObserver().getAID());
            if (context != null && !isDebug && !aidIsValid) {
                androidID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            }
            if (androidID == null) {
                if (isDebug) {
                    androidID = UUID.randomUUID().toString();
                } else {
                    String randomlyGeneratedUuid = PrefHelper.getInstance(context).getRandomlyGeneratedUuid();
                    if (!TextUtils.isEmpty((CharSequence)randomlyGeneratedUuid) && !randomlyGeneratedUuid.equals(SystemObserver.BLANK)) {
                        androidID = randomlyGeneratedUuid;
                    } else {
                        androidID = UUID.randomUUID().toString();
                        PrefHelper.getInstance(context).setRandomlyGeneratedUuid(androidID);
                    }
                }
                this.isRealId = false;
            }
            this.uniqueId = androidID;
        }

        String getId() {
            return this.uniqueId;
        }

        boolean isReal() {
            return this.isRealId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            UniqueId uidOther = (UniqueId)other;
            return this.uniqueId.equals(uidOther.uniqueId) && this.isRealId == uidOther.isRealId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1 + (this.isRealId ? 1 : 0);
            return 31 * result + (this.uniqueId == null ? 0 : this.uniqueId.hashCode());
        }
    }

    static interface AdsParamsFetchEvents {
        public void onAdsParamsFetchFinished();
    }

    static interface InstallReferrerFetchEvents {
        public void onInstallReferrersFinished();
    }
}

