/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import io.branch.referral.Branch;
import io.branch.referral.BranchAsyncTask;
import io.branch.referral.BranchLinkData;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerRequestCreateUrl;
import io.branch.referral.ServerRequestInitSession;
import io.branch.referral.ServerRequestRegisterInstall;
import io.branch.referral.ServerResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerRequestQueue {
    private static final String PREF_KEY = "BNCServerRequestQueue";
    private static final int MAX_ITEMS = 25;
    private static ServerRequestQueue SharedInstance;
    private SharedPreferences sharedPref;
    private SharedPreferences.Editor editor;
    private final List<ServerRequest> queue;
    private static final Object reqQueueLockObject;
    private final Semaphore serverSema_ = new Semaphore(1);
    int networkCount_ = 0;
    final ConcurrentHashMap<String, String> instrumentationExtraData_ = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerRequestQueue getInstance(Context c) {
        if (SharedInstance != null) return SharedInstance;
        Class<ServerRequestQueue> clazz = ServerRequestQueue.class;
        synchronized (ServerRequestQueue.class) {
            if (SharedInstance != null) return SharedInstance;
            SharedInstance = new ServerRequestQueue(c);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SharedInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutDown() {
        Object object = reqQueueLockObject;
        synchronized (object) {
            SharedInstance = null;
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private ServerRequestQueue(Context c) {
        this.sharedPref = c.getSharedPreferences("BNC_Server_Request_Queue", 0);
        this.editor = this.sharedPref.edit();
        this.queue = this.retrieve(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist() {
        try {
            JSONArray jsonArr = new JSONArray();
            Object object = reqQueueLockObject;
            synchronized (object) {
                for (ServerRequest aQueue : this.queue) {
                    JSONObject json;
                    if (!aQueue.isPersistable() || (json = aQueue.toJSON()) == null) continue;
                    jsonArr.put((Object)json);
                }
            }
            this.editor.putString(PREF_KEY, jsonArr.toString()).apply();
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            BranchLogger.e("Failed to persist queue" + (msg == null ? "" : msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServerRequest> retrieve(Context context) {
        String jsonStr = this.sharedPref.getString(PREF_KEY, null);
        List<ServerRequest> result = Collections.synchronizedList(new LinkedList());
        Object object = reqQueueLockObject;
        synchronized (object) {
            if (jsonStr != null) {
                try {
                    JSONArray jsonArr = new JSONArray(jsonStr);
                    int size = Math.min(jsonArr.length(), 25);
                    for (int i = 0; i < size; ++i) {
                        JSONObject json = jsonArr.getJSONObject(i);
                        ServerRequest req = ServerRequest.fromJSON(json, context);
                        if (req == null) continue;
                        result.add(req);
                    }
                }
                catch (JSONException e) {
                    BranchLogger.w("Caught JSONException " + e.getMessage());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = reqQueueLockObject;
        synchronized (object) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(ServerRequest request) {
        Object object = reqQueueLockObject;
        synchronized (object) {
            if (request != null) {
                this.queue.add(request);
                if (this.getSize() >= 25) {
                    this.queue.remove(1);
                }
                this.persist();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerRequest peek() {
        ServerRequest req = null;
        Object object = reqQueueLockObject;
        synchronized (object) {
            try {
                req = this.queue.get(0);
            }
            catch (IndexOutOfBoundsException | NoSuchElementException e) {
                BranchLogger.w("Caught Exception " + e.getMessage());
            }
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printQueue() {
        if (BranchLogger.getLoggingLevel().getLevel() == BranchLogger.BranchLogLevel.VERBOSE.getLevel()) {
            Object object = reqQueueLockObject;
            synchronized (object) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < this.queue.size(); ++i) {
                    stringBuilder.append(this.queue.get(i)).append(" with locks ").append(this.queue.get(i).printWaitLocks()).append("\n");
                }
                BranchLogger.v("Queue is: " + stringBuilder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerRequest peekAt(int index) {
        ServerRequest req = null;
        Object object = reqQueueLockObject;
        synchronized (object) {
            try {
                req = this.queue.get(index);
            }
            catch (IndexOutOfBoundsException | NoSuchElementException e) {
                BranchLogger.e("Caught Exception " + e.getMessage());
            }
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(ServerRequest request, int index) {
        Object object = reqQueueLockObject;
        synchronized (object) {
            try {
                if (this.queue.size() < index) {
                    index = this.queue.size();
                }
                this.queue.add(index, request);
                this.persist();
            }
            catch (IndexOutOfBoundsException e) {
                BranchLogger.e("Caught IndexOutOfBoundsException " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerRequest removeAt(int index) {
        ServerRequest req = null;
        Object object = reqQueueLockObject;
        synchronized (object) {
            try {
                req = this.queue.remove(index);
                this.persist();
            }
            catch (IndexOutOfBoundsException e) {
                BranchLogger.e("Caught IndexOutOfBoundsException " + e.getMessage());
            }
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ServerRequest request) {
        boolean isRemoved = false;
        Object object = reqQueueLockObject;
        synchronized (object) {
            try {
                isRemoved = this.queue.remove(request);
                this.persist();
            }
            catch (UnsupportedOperationException e) {
                BranchLogger.e("Caught UnsupportedOperationException " + e.getMessage());
            }
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = reqQueueLockObject;
        synchronized (object) {
            try {
                this.queue.clear();
                this.persist();
            }
            catch (UnsupportedOperationException e) {
                BranchLogger.e("Caught UnsupportedOperationException " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerRequestInitSession getSelfInitRequest() {
        Object object = reqQueueLockObject;
        synchronized (object) {
            for (ServerRequest req : this.queue) {
                if (!(req instanceof ServerRequestInitSession)) continue;
                ServerRequestInitSession r = (ServerRequestInitSession)req;
                if (!r.initiatedByClient) continue;
                return r;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK lock) {
        Object object = reqQueueLockObject;
        synchronized (object) {
            for (ServerRequest req : this.queue) {
                if (req == null) continue;
                req.removeProcessWaitLock(lock);
            }
        }
    }

    public void postInitClear() {
        PrefHelper prefHelper_ = Branch.getInstance().getPrefHelper();
        boolean canClear = this.canClearInitData();
        BranchLogger.v("postInitClear " + prefHelper_ + " can clear init data " + canClear);
        if (prefHelper_ != null && canClear) {
            prefHelper_.setLinkClickIdentifier("bnc_no_value");
            prefHelper_.setGoogleSearchInstallIdentifier("bnc_no_value");
            prefHelper_.setAppStoreReferrer("bnc_no_value");
            prefHelper_.setExternalIntentUri("bnc_no_value");
            prefHelper_.setExternalIntentExtra("bnc_no_value");
            prefHelper_.setAppLink("bnc_no_value");
            prefHelper_.setPushIdentifier("bnc_no_value");
            prefHelper_.setInstallReferrerParams("bnc_no_value");
            prefHelper_.setIsFullAppConversion(false);
            prefHelper_.setInitialReferrer("bnc_no_value");
            if (prefHelper_.getLong("bnc_previous_update_time") == 0L) {
                prefHelper_.setLong("bnc_previous_update_time", prefHelper_.getLong("bnc_last_known_update_time"));
            }
        }
    }

    void processNextQueueItem(String callingMethodName) {
        BranchLogger.v("processNextQueueItem " + callingMethodName);
        this.printQueue();
        try {
            this.serverSema_.acquire();
            if (this.networkCount_ == 0 && this.getSize() > 0) {
                this.networkCount_ = 1;
                ServerRequest req = this.peek();
                this.serverSema_.release();
                if (req != null) {
                    BranchLogger.d("processNextQueueItem, req " + req);
                    if (!req.isWaitingOnProcessToFinish()) {
                        if (!(req instanceof ServerRequestRegisterInstall) && !this.hasUser()) {
                            BranchLogger.d("Branch Error: User session has not been initialized!");
                            this.networkCount_ = 0;
                            req.handleFailure(-101, "");
                        } else if (this.requestNeedsSession(req) && !this.isSessionAvailableForRequest()) {
                            this.networkCount_ = 0;
                            req.handleFailure(-101, "");
                        } else {
                            this.executeTimedBranchPostTask(req, Branch.getInstance().prefHelper_.getTaskTimeout());
                        }
                    } else {
                        this.networkCount_ = 0;
                    }
                } else {
                    this.remove(null);
                }
            } else {
                this.serverSema_.release();
            }
        }
        catch (Exception e) {
            BranchLogger.e("Caught Exception " + e.getMessage() + BranchLogger.stackTraceToString(e));
        }
    }

    void insertRequestAtFront(ServerRequest req) {
        if (this.networkCount_ == 0) {
            this.insert(req, 0);
        } else {
            this.insert(req, 1);
        }
    }

    private boolean requestNeedsSession(ServerRequest request) {
        if (request instanceof ServerRequestInitSession) {
            return false;
        }
        return !(request instanceof ServerRequestCreateUrl);
    }

    private boolean isSessionAvailableForRequest() {
        return this.hasSession() && this.hasRandomizedDeviceToken();
    }

    private boolean hasSession() {
        return !Branch.getInstance().prefHelper_.getSessionID().equals("bnc_no_value");
    }

    private boolean hasRandomizedDeviceToken() {
        return !Branch.getInstance().prefHelper_.getRandomizedDeviceToken().equals("bnc_no_value");
    }

    boolean hasUser() {
        return !Branch.getInstance().prefHelper_.getRandomizedBundleToken().equals("bnc_no_value");
    }

    void updateAllRequestsInQueue() {
        try {
            for (int i = 0; i < this.getSize(); ++i) {
                JSONObject reqJson;
                ServerRequest req = this.peekAt(i);
                if (req == null || (reqJson = req.getPost()) == null) continue;
                if (reqJson.has(Defines.Jsonkey.SessionID.getKey())) {
                    req.getPost().put(Defines.Jsonkey.SessionID.getKey(), (Object)Branch.getInstance().prefHelper_.getSessionID());
                }
                if (reqJson.has(Defines.Jsonkey.RandomizedBundleToken.getKey())) {
                    req.getPost().put(Defines.Jsonkey.RandomizedBundleToken.getKey(), (Object)Branch.getInstance().prefHelper_.getRandomizedBundleToken());
                }
                if (!reqJson.has(Defines.Jsonkey.RandomizedDeviceToken.getKey())) continue;
                req.getPost().put(Defines.Jsonkey.RandomizedDeviceToken.getKey(), (Object)Branch.getInstance().prefHelper_.getRandomizedDeviceToken());
            }
        }
        catch (JSONException e) {
            BranchLogger.e("Caught JSONException " + e.getMessage());
        }
    }

    private void executeTimedBranchPostTask(ServerRequest req, final int timeout) {
        BranchLogger.v("executeTimedBranchPostTask " + req);
        if (req instanceof ServerRequestInitSession) {
            BranchLogger.v("callback to be returned " + ((ServerRequestInitSession)req).callback_);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final BranchPostTask postTask = new BranchPostTask(req, latch);
        postTask.executeTask(new Void[0]);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ServerRequestQueue.this.awaitTimedBranchPostTask(latch, timeout, postTask);
                }
            }).start();
        } else {
            this.awaitTimedBranchPostTask(latch, timeout, postTask);
        }
    }

    private void awaitTimedBranchPostTask(CountDownLatch latch, int timeout, BranchPostTask postTask) {
        try {
            if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
                postTask.cancel(true);
                postTask.onPostExecuteInner(new ServerResponse(postTask.thisReq_.getRequestPath(), -120, "", ""));
            }
        }
        catch (InterruptedException e) {
            BranchLogger.e("Caught InterruptedException " + e.getMessage());
            postTask.cancel(true);
            postTask.onPostExecuteInner(new ServerResponse(postTask.thisReq_.getRequestPath(), -120, "", e.getMessage()));
        }
    }

    public void handleNewRequest(ServerRequest req) {
        BranchLogger.d("handleNewRequest " + req);
        if (Branch.getInstance().getTrackingController().isTrackingDisabled() && !req.prepareExecuteWithoutTracking()) {
            BranchLogger.d("Requested operation cannot be completed since tracking is disabled [" + req.requestPath_.getPath() + "]");
            req.handleFailure(-117, "");
            return;
        }
        if (Branch.getInstance().initState_ != Branch.SESSION_STATE.INITIALISED && !(req instanceof ServerRequestInitSession) && this.requestNeedsSession(req)) {
            BranchLogger.d("handleNewRequest " + req + " needs a session");
            req.addProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.SDK_INIT_WAIT_LOCK);
        }
        this.enqueue(req);
        req.onRequestQueued();
        this.processNextQueueItem("handleNewRequest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canClearInitData() {
        int result = 0;
        Object object = reqQueueLockObject;
        synchronized (object) {
            for (int i = 0; i < this.queue.size(); ++i) {
                if (!(this.queue.get(i) instanceof ServerRequestInitSession)) continue;
                ++result;
            }
        }
        return result <= 1;
    }

    public void addExtraInstrumentationData(HashMap<String, String> instrumentationData) {
        this.instrumentationExtraData_.putAll(instrumentationData);
    }

    public void addExtraInstrumentationData(String key, String value) {
        this.instrumentationExtraData_.put(key, value);
    }

    static {
        reqQueueLockObject = new Object();
    }

    private class BranchPostTask
    extends BranchAsyncTask<Void, Void, ServerResponse> {
        ServerRequest thisReq_;
        final CountDownLatch latch_;

        public BranchPostTask(ServerRequest request, CountDownLatch latch) {
            this.thisReq_ = request;
            this.latch_ = latch;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.thisReq_.onPreExecute();
            this.thisReq_.doFinalUpdateOnMainThread();
        }

        protected ServerResponse doInBackground(Void ... voids) {
            ServerResponse result;
            this.thisReq_.doFinalUpdateOnBackgroundThread();
            if (Branch.getInstance().getTrackingController().isTrackingDisabled() && !this.thisReq_.prepareExecuteWithoutTracking()) {
                return new ServerResponse(this.thisReq_.getRequestPath(), -117, "", "");
            }
            String branchKey = Branch.getInstance().prefHelper_.getBranchKey();
            if (this.thisReq_.isGetRequest()) {
                result = Branch.getInstance().getBranchRemoteInterface().make_restful_get(this.thisReq_.getRequestUrl(), this.thisReq_.getGetParams(), this.thisReq_.getRequestPath(), branchKey);
            } else {
                BranchLogger.v("Beginning rest post for " + this.thisReq_);
                result = Branch.getInstance().getBranchRemoteInterface().make_restful_post(this.thisReq_.getPostWithInstrumentationValues(ServerRequestQueue.this.instrumentationExtraData_), this.thisReq_.getRequestUrl(), this.thisReq_.getRequestPath(), branchKey);
            }
            if (this.latch_ != null) {
                this.latch_.countDown();
            }
            return result;
        }

        protected void onPostExecute(ServerResponse serverResponse) {
            super.onPostExecute((Object)serverResponse);
            this.onPostExecuteInner(serverResponse);
        }

        void onPostExecuteInner(ServerResponse serverResponse) {
            BranchLogger.v("onPostExecuteInner " + (Object)((Object)this) + " " + serverResponse);
            if (this.latch_ != null) {
                this.latch_.countDown();
            }
            if (serverResponse == null) {
                this.thisReq_.handleFailure(-116, "Null response.");
                return;
            }
            int status = serverResponse.getStatusCode();
            if (status == 200) {
                this.onRequestSuccess(serverResponse);
            } else {
                this.onRequestFailed(serverResponse, status);
            }
            ServerRequestQueue.this.networkCount_ = 0;
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    ServerRequestQueue.this.processNextQueueItem("onPostExecuteInner");
                }
            });
        }

        private void onRequestSuccess(ServerResponse serverResponse) {
            BranchLogger.v("onRequestSuccess " + serverResponse);
            JSONObject respJson = serverResponse.getObject();
            if (respJson == null) {
                this.thisReq_.handleFailure(500, "Null response json.");
            }
            if (this.thisReq_ instanceof ServerRequestCreateUrl && respJson != null) {
                try {
                    BranchLinkData postBody = ((ServerRequestCreateUrl)this.thisReq_).getLinkPost();
                    String url = respJson.getString("url");
                    Branch.getInstance().linkCache_.put(postBody, url);
                }
                catch (JSONException ex) {
                    BranchLogger.w("Caught JSONException " + ex.getMessage());
                }
            }
            if (this.thisReq_ instanceof ServerRequestInitSession) {
                boolean updateRequestsInQueue = false;
                if (!Branch.getInstance().isTrackingDisabled() && respJson != null) {
                    try {
                        if (respJson.has(Defines.Jsonkey.SessionID.getKey())) {
                            Branch.getInstance().prefHelper_.setSessionID(respJson.getString(Defines.Jsonkey.SessionID.getKey()));
                            updateRequestsInQueue = true;
                        }
                        if (respJson.has(Defines.Jsonkey.RandomizedBundleToken.getKey())) {
                            String new_Randomized_Bundle_Token = respJson.getString(Defines.Jsonkey.RandomizedBundleToken.getKey());
                            if (!Branch.getInstance().prefHelper_.getRandomizedBundleToken().equals(new_Randomized_Bundle_Token)) {
                                Branch.getInstance().linkCache_.clear();
                                Branch.getInstance().prefHelper_.setRandomizedBundleToken(new_Randomized_Bundle_Token);
                                updateRequestsInQueue = true;
                            }
                        }
                        if (respJson.has(Defines.Jsonkey.RandomizedDeviceToken.getKey())) {
                            Branch.getInstance().prefHelper_.setRandomizedDeviceToken(respJson.getString(Defines.Jsonkey.RandomizedDeviceToken.getKey()));
                            updateRequestsInQueue = true;
                        }
                        if (updateRequestsInQueue) {
                            ServerRequestQueue.this.updateAllRequestsInQueue();
                        }
                    }
                    catch (JSONException ex) {
                        BranchLogger.w("Caught JSONException " + ex.getMessage());
                    }
                }
                if (this.thisReq_ instanceof ServerRequestInitSession) {
                    Branch.getInstance().setInitState(Branch.SESSION_STATE.INITIALISED);
                    Branch.getInstance().checkForAutoDeepLinkConfiguration();
                    if (Branch.getInstance().getLatestReferringParamsLatch != null) {
                        Branch.getInstance().getLatestReferringParamsLatch.countDown();
                    }
                    if (Branch.getInstance().getFirstReferringParamsLatch != null) {
                        Branch.getInstance().getFirstReferringParamsLatch.countDown();
                    }
                }
            }
            if (respJson != null) {
                this.thisReq_.onRequestSucceeded(serverResponse, Branch.getInstance());
                ServerRequestQueue.this.remove(this.thisReq_);
            } else if (this.thisReq_.shouldRetryOnFail()) {
                this.thisReq_.clearCallbacks();
            } else {
                ServerRequestQueue.this.remove(this.thisReq_);
            }
        }

        void onRequestFailed(ServerResponse serverResponse, int status) {
            boolean unretryableErrorCode;
            BranchLogger.v("onRequestFailed " + serverResponse.getMessage());
            if (this.thisReq_ instanceof ServerRequestInitSession && "bnc_no_value".equals(Branch.getInstance().prefHelper_.getSessionParams())) {
                Branch.getInstance().setInitState(Branch.SESSION_STATE.UNINITIALISED);
            }
            if ((status == 400 || status == 409) && this.thisReq_ instanceof ServerRequestCreateUrl) {
                ((ServerRequestCreateUrl)this.thisReq_).handleDuplicateURLError();
            } else {
                ServerRequestQueue.this.networkCount_ = 0;
                this.thisReq_.handleFailure(status, serverResponse.getFailReason() + " " + serverResponse.getMessage());
            }
            boolean bl = unretryableErrorCode = 400 <= status && status <= 451 || status == -117;
            if (unretryableErrorCode || !this.thisReq_.shouldRetryOnFail() || this.thisReq_.currentRetryCount >= Branch.getInstance().prefHelper_.getNoConnectionRetryMax()) {
                Branch.getInstance().requestQueue_.remove(this.thisReq_);
            } else {
                this.thisReq_.clearCallbacks();
            }
            ++this.thisReq_.currentRetryCount;
        }
    }
}

