/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerRequestGetLATD
extends ServerRequest {
    private BranchLastAttributedTouchDataListener callback;
    protected static final int defaultAttributionWindow = -1;
    private int attributionWindow;

    ServerRequestGetLATD(Context context, Defines.RequestPath requestPath, BranchLastAttributedTouchDataListener callback) {
        this(context, requestPath, callback, PrefHelper.getInstance(context).getLATDAttributionWindow());
    }

    ServerRequestGetLATD(Context context, Defines.RequestPath requestPath, BranchLastAttributedTouchDataListener callback, int attributionWindow) {
        super(context, requestPath);
        this.callback = callback;
        this.attributionWindow = attributionWindow;
        JSONObject reqBody = new JSONObject();
        try {
            this.setPost(reqBody);
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException " + e.getMessage());
        }
        this.updateEnvironment(context, reqBody);
    }

    protected int getAttributionWindow() {
        return this.attributionWindow;
    }

    @Override
    public boolean handleErrors(Context context) {
        return false;
    }

    @Override
    public void onRequestSucceeded(ServerResponse response, Branch branch) {
        if (this.callback == null) {
            return;
        }
        if (response != null) {
            this.callback.onDataFetched(response.getObject(), null);
        } else {
            this.handleFailure(-116, "Failed to get last attributed touch data");
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback != null) {
            this.callback.onDataFetched(null, new BranchError("Failed to get last attributed touch data", statusCode));
        }
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        this.callback = null;
    }

    @Override
    public ServerRequest.BRANCH_API_VERSION getBranchRemoteAPIVersion() {
        return ServerRequest.BRANCH_API_VERSION.V1_LATD;
    }

    @Override
    protected boolean shouldUpdateLimitFacebookTracking() {
        return true;
    }

    public static interface BranchLastAttributedTouchDataListener {
        public void onDataFetched(JSONObject var1, BranchError var2);
    }
}

