/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.Base64;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.BranchLinkData;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestCreateUrl
extends ServerRequest {
    private BranchLinkData linkPost_;
    private boolean isAsync_ = true;
    private Branch.BranchLinkCreateListener callback_;
    private static final String DEF_BASE_URL = "https://bnc.lt/a/";
    private boolean defaultToLongUrl_ = true;

    public ServerRequestCreateUrl(Context context, String alias, int type, int duration, Collection<String> tags, String channel, String feature, String stage, String campaign, JSONObject params, Branch.BranchLinkCreateListener callback, boolean async, boolean defaultToLongUrl) {
        super(context, Defines.RequestPath.GetURL);
        this.callback_ = callback;
        this.isAsync_ = async;
        this.defaultToLongUrl_ = defaultToLongUrl;
        this.linkPost_ = new BranchLinkData();
        try {
            if (!this.prefHelper_.getLinkClickID().equals("bnc_no_value")) {
                this.linkPost_.put(Defines.Jsonkey.LinkClickID.getKey(), this.prefHelper_.getLinkClickID());
            }
            this.linkPost_.putType(type);
            this.linkPost_.putDuration(duration);
            this.linkPost_.putTags(tags);
            this.linkPost_.putAlias(alias);
            this.linkPost_.putChannel(channel);
            this.linkPost_.putFeature(feature);
            this.linkPost_.putStage(stage);
            this.linkPost_.putCampaign(campaign);
            this.linkPost_.putParams(params);
            this.linkPost_.putSource();
            this.setPost(this.linkPost_);
            this.linkPost_.remove("anon_id");
            this.linkPost_.remove("is_hardware_id_real");
            this.linkPost_.remove("hardware_id");
        }
        catch (JSONException ex) {
            BranchLogger.w("Caught JSONException " + ex.getMessage());
            this.constructError_ = true;
        }
    }

    public ServerRequestCreateUrl(Defines.RequestPath requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
    }

    public BranchLinkData getLinkPost() {
        return this.linkPost_;
    }

    boolean isDefaultToLongUrl() {
        return this.defaultToLongUrl_;
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null) {
                this.callback_.onLinkCreate(null, new BranchError("Trouble creating a URL.", -102));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        try {
            String url = resp.getObject().getString("url");
            if (this.callback_ != null) {
                this.callback_.onLinkCreate(url, null);
            }
        }
        catch (Exception ex) {
            BranchLogger.e("Caught Exception " + BranchLogger.stackTraceToString(ex));
        }
    }

    public void onUrlAvailable(String url) {
        if (this.callback_ != null) {
            this.callback_.onLinkCreate(url, null);
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            String failedUrl = null;
            if (this.defaultToLongUrl_) {
                failedUrl = this.getLongUrl();
            }
            this.callback_.onLinkCreate(failedUrl, new BranchError("Trouble creating a URL. " + causeMsg, statusCode));
        }
    }

    public String getLongUrl() {
        String longUrl = !this.prefHelper_.getUserURL().equals("bnc_no_value") ? this.generateLongUrlWithParams(this.prefHelper_.getUserURL()) : this.generateLongUrlWithParams(DEF_BASE_URL + this.prefHelper_.getBranchKey());
        return longUrl;
    }

    public void handleDuplicateURLError() {
        if (this.callback_ != null) {
            this.callback_.onLinkCreate(null, new BranchError("Trouble creating a URL.", -105));
        }
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        this.callback_ = null;
    }

    public boolean isAsync() {
        return this.isAsync_;
    }

    private String generateLongUrlWithParams(String baseUrl) {
        String longUrl = baseUrl;
        try {
            String campaign;
            String stage;
            String feature;
            String channel;
            String alias;
            if (Branch.getInstance().isTrackingDisabled() && !longUrl.contains(DEF_BASE_URL)) {
                longUrl = longUrl.replace(new URL(longUrl).getQuery(), "");
            }
            longUrl = longUrl + (longUrl.contains("?") ? "" : "?");
            longUrl = longUrl + (longUrl.endsWith("?") ? "" : "&");
            Collection<String> tags = this.linkPost_.getTags();
            if (tags != null) {
                for (String tag : tags) {
                    if (tag == null || tag.length() <= 0) continue;
                    longUrl = longUrl + (Object)((Object)Defines.LinkParam.Tags) + "=" + URLEncoder.encode(tag, "UTF8") + "&";
                }
            }
            if ((alias = this.linkPost_.getAlias()) != null && alias.length() > 0) {
                longUrl = longUrl + (Object)((Object)Defines.LinkParam.Alias) + "=" + URLEncoder.encode(alias, "UTF8") + "&";
            }
            if ((channel = this.linkPost_.getChannel()) != null && channel.length() > 0) {
                longUrl = longUrl + (Object)((Object)Defines.LinkParam.Channel) + "=" + URLEncoder.encode(channel, "UTF8") + "&";
            }
            if ((feature = this.linkPost_.getFeature()) != null && feature.length() > 0) {
                longUrl = longUrl + (Object)((Object)Defines.LinkParam.Feature) + "=" + URLEncoder.encode(feature, "UTF8") + "&";
            }
            if ((stage = this.linkPost_.getStage()) != null && stage.length() > 0) {
                longUrl = longUrl + (Object)((Object)Defines.LinkParam.Stage) + "=" + URLEncoder.encode(stage, "UTF8") + "&";
            }
            if ((campaign = this.linkPost_.getCampaign()) != null && campaign.length() > 0) {
                longUrl = longUrl + (Object)((Object)Defines.LinkParam.Campaign) + "=" + URLEncoder.encode(campaign, "UTF8") + "&";
            }
            long type = this.linkPost_.getType();
            longUrl = longUrl + (Object)((Object)Defines.LinkParam.Type) + "=" + type + "&";
            long duration = this.linkPost_.getDuration();
            longUrl = longUrl + (Object)((Object)Defines.LinkParam.Duration) + "=" + duration;
            String source = Defines.Jsonkey.URLSource.getKey();
            longUrl = longUrl + "&source=" + source;
            JSONObject params = this.linkPost_.getParams();
            if (params != null && params.length() > 0) {
                String paramsString = params.toString();
                byte[] data = paramsString.getBytes();
                String base64Data = Base64.encodeToString(data, 2);
                String urlEncodedBase64Data = URLEncoder.encode(base64Data, "UTF8");
                longUrl = longUrl + "&data=" + urlEncodedBase64Data;
            }
        }
        catch (Exception exception) {
            BranchLogger.e("Caught Exception " + BranchLogger.stackTraceToString(exception));
            this.callback_.onLinkCreate(null, new BranchError("Trouble creating a URL.", -116));
        }
        return longUrl;
    }

    @Override
    boolean isPersistable() {
        return false;
    }

    @Override
    protected boolean prepareExecuteWithoutTracking() {
        return true;
    }
}

