/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.QRCode;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import androidx.annotation.NonNull;
import io.branch.indexing.BranchUniversalObject;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.BranchQRCodeCache;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import io.branch.referral.QRCode.ServerRequestCreateQRCode;
import io.branch.referral.ServerResponse;
import io.branch.referral.util.LinkProperties;
import java.io.IOException;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchQRCode {
    private String codeColor_ = null;
    private String backgroundColor_ = null;
    private String centerLogo_ = null;
    private Integer width_ = null;
    private Integer margin_ = null;
    private BranchImageFormat imageFormat_ = null;

    public BranchQRCode setCodeColor(@NonNull int codeColor) {
        String codeColorString = String.format("#%06X", 0xFFFFFF & codeColor);
        return this.setCodeColor(codeColorString);
    }

    public BranchQRCode setCodeColor(@NonNull String hexCodeColor) {
        this.codeColor_ = hexCodeColor;
        return this;
    }

    public BranchQRCode setBackgroundColor(@NonNull int backgroundColor) {
        String backgroundColorString = String.format("#%06X", 0xFFFFFF & backgroundColor);
        return this.setBackgroundColor(backgroundColorString);
    }

    public BranchQRCode setBackgroundColor(@NonNull String hexBackgroundColor) {
        this.backgroundColor_ = hexBackgroundColor;
        return this;
    }

    public BranchQRCode setCenterLogo(@NonNull String centerLogo) {
        this.centerLogo_ = centerLogo;
        return this;
    }

    public BranchQRCode setWidth(@NonNull Integer width) {
        if (width > 2000) {
            BranchLogger.v("Width was reduced to the maximum of 2000.");
            this.width_ = 2000;
        } else if (width < 300) {
            BranchLogger.v("Width was increased to the minimum of 300.");
            this.width_ = 300;
        } else {
            this.width_ = width;
        }
        return this;
    }

    public BranchQRCode setMargin(@NonNull Integer margin) {
        if (margin > 20) {
            BranchLogger.v("Margin was reduced to the maximum of 20.");
            this.margin_ = 20;
        } else if (margin < 1) {
            BranchLogger.v("Margin was increased to the minimum of 1.");
            this.margin_ = 1;
        } else {
            this.margin_ = margin;
        }
        return this;
    }

    public BranchQRCode setImageFormat(@NonNull BranchImageFormat imageFormat) {
        this.imageFormat_ = imageFormat;
        return this;
    }

    public void getQRCodeAsData(@NonNull Context context, @NonNull BranchUniversalObject branchUniversalObject, @NonNull LinkProperties linkProperties, final @NonNull BranchQRCodeDataHandler callback) throws IOException {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        if (this.codeColor_ != null) {
            settings.put(Defines.Jsonkey.CodeColor.getKey(), this.codeColor_);
        }
        if (this.backgroundColor_ != null) {
            settings.put(Defines.Jsonkey.BackgroundColor.getKey(), this.backgroundColor_);
        }
        if (this.width_ != null) {
            settings.put(Defines.Jsonkey.Width.getKey(), this.width_);
        }
        if (this.margin_ != null) {
            settings.put(Defines.Jsonkey.Margin.getKey(), this.margin_);
        }
        if (this.imageFormat_ == BranchImageFormat.JPEG) {
            settings.put(Defines.Jsonkey.ImageFormat.getKey(), "JPEG");
        } else {
            settings.put(Defines.Jsonkey.ImageFormat.getKey(), "PNG");
        }
        if (this.centerLogo_ != null) {
            settings.put(Defines.Jsonkey.CenterLogo.getKey(), this.centerLogo_);
        }
        final HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (linkProperties.getChannel() != null) {
            parameters.put(Defines.LinkParam.Channel.getKey(), linkProperties.getChannel());
        }
        if (linkProperties.getFeature() != null) {
            parameters.put(Defines.LinkParam.Feature.getKey(), linkProperties.getFeature());
        }
        if (linkProperties.getCampaign() != null) {
            parameters.put(Defines.LinkParam.Campaign.getKey(), linkProperties.getCampaign());
        }
        if (linkProperties.getStage() != null) {
            parameters.put(Defines.LinkParam.Stage.getKey(), linkProperties.getStage());
        }
        if (linkProperties.getTags() != null) {
            parameters.put(Defines.LinkParam.Tags.getKey(), linkProperties.getTags());
        }
        parameters.put(Defines.Jsonkey.QRCodeSettings.getKey(), settings);
        parameters.put(Defines.Jsonkey.QRCodeData.getKey(), branchUniversalObject.convertToJson());
        parameters.put(Defines.Jsonkey.QRCodeBranchKey.getKey(), PrefHelper.getInstance(context).getBranchKey());
        JSONObject paramsJSON = new JSONObject(parameters);
        byte[] cachedQRCode = BranchQRCodeCache.getInstance().checkQRCodeCache(paramsJSON);
        if (cachedQRCode != null) {
            callback.onSuccess(cachedQRCode);
            return;
        }
        ServerRequestCreateQRCode req = new ServerRequestCreateQRCode(Defines.RequestPath.QRCode, paramsJSON, context, new BranchQRCodeRequestHandler(){

            @Override
            public void onDataReceived(ServerResponse data) {
                try {
                    String qrCodeString = data.getObject().getString(Defines.Jsonkey.QRCodeResponseString.getKey());
                    byte[] qrCodeBytes = Base64.decode((String)qrCodeString, (int)0);
                    JSONObject cacheParamsJSON = new JSONObject(parameters);
                    BranchQRCodeCache.getInstance().addQRCodeToCache(cacheParamsJSON, qrCodeBytes);
                    callback.onSuccess(qrCodeBytes);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    callback.onFailure((Exception)((Object)e));
                }
            }

            @Override
            public void onFailure(Exception e) {
                callback.onFailure(e);
            }
        });
        Branch.getInstance().requestQueue_.handleNewRequest(req);
    }

    public void getQRCodeAsImage(@NonNull Activity activity, @NonNull BranchUniversalObject branchUniversalObject, @NonNull LinkProperties linkProperties, final @NonNull BranchQRCodeImageHandler callback) throws IOException {
        this.getQRCodeAsData((Context)activity, branchUniversalObject, linkProperties, new BranchQRCodeDataHandler(){

            @Override
            public void onSuccess(byte[] qrCodeData) {
                Bitmap bmp = BitmapFactory.decodeByteArray((byte[])qrCodeData, (int)0, (int)qrCodeData.length);
                callback.onSuccess(bmp);
            }

            @Override
            public void onFailure(Exception e) {
                callback.onFailure(e);
            }
        });
    }

    public static enum BranchImageFormat {
        JPEG,
        PNG;

    }

    public static interface BranchQRCodeDataHandler<T> {
        public void onSuccess(byte[] var1);

        public void onFailure(Exception var1);
    }

    public static interface BranchQRCodeRequestHandler<T> {
        public void onDataReceived(ServerResponse var1);

        public void onFailure(Exception var1);
    }

    public static interface BranchQRCodeImageHandler<T> {
        public void onSuccess(Bitmap var1);

        public void onFailure(Exception var1);
    }
}

