/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.app.UiModeManager;
import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import io.branch.coroutines.DeviceSignalsKt;
import io.branch.referral.Branch;
import io.branch.referral.BranchLogger;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerRequestGetLATD;
import io.branch.referral.SystemObserver;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import org.json.JSONException;
import org.json.JSONObject;

class DeviceInfo {
    private final SystemObserver systemObserver_;
    private final Context context_;

    static DeviceInfo getInstance() {
        Branch b = Branch.getInstance();
        if (b == null) {
            return null;
        }
        return b.getDeviceInfo();
    }

    DeviceInfo(Context context) {
        this.context_ = context;
        this.systemObserver_ = new SystemObserverInstance();
    }

    void updateRequestWithV1Params(ServerRequest serverRequest, JSONObject requestObj) {
        try {
            String localIpAddr;
            String languageCode;
            String countryCode;
            String modelName;
            String brandName;
            String anonID;
            SystemObserver.UniqueId hardwareID = this.getHardwareID();
            if (!DeviceInfo.isNullOrEmptyOrBlank(hardwareID.getId())) {
                requestObj.put(Defines.Jsonkey.HardwareID.getKey(), (Object)hardwareID.getId());
                requestObj.put(Defines.Jsonkey.IsHardwareIDReal.getKey(), hardwareID.isReal());
            }
            if (!DeviceInfo.isNullOrEmptyOrBlank(anonID = SystemObserver.getAnonID(this.context_))) {
                requestObj.put(Defines.Jsonkey.AnonID.getKey(), (Object)anonID);
            }
            if (!DeviceInfo.isNullOrEmptyOrBlank(brandName = SystemObserver.getPhoneBrand())) {
                requestObj.put(Defines.Jsonkey.Brand.getKey(), (Object)brandName);
            }
            if (!DeviceInfo.isNullOrEmptyOrBlank(modelName = SystemObserver.getPhoneModel())) {
                requestObj.put(Defines.Jsonkey.Model.getKey(), (Object)modelName);
            }
            DisplayMetrics displayMetrics = SystemObserver.getScreenDisplay(this.context_);
            requestObj.put(Defines.Jsonkey.ScreenDpi.getKey(), displayMetrics.densityDpi);
            requestObj.put(Defines.Jsonkey.ScreenHeight.getKey(), displayMetrics.heightPixels);
            requestObj.put(Defines.Jsonkey.ScreenWidth.getKey(), displayMetrics.widthPixels);
            requestObj.put(Defines.Jsonkey.WiFi.getKey(), SystemObserver.getWifiConnected(this.context_));
            requestObj.put(Defines.Jsonkey.UIMode.getKey(), (Object)SystemObserver.getUIMode(this.context_));
            String osName = SystemObserver.getOS(this.context_);
            if (!DeviceInfo.isNullOrEmptyOrBlank(osName)) {
                requestObj.put(Defines.Jsonkey.OS.getKey(), (Object)osName);
            }
            requestObj.put(Defines.Jsonkey.APILevel.getKey(), SystemObserver.getAPILevel());
            if (Branch.getPluginName() != null) {
                requestObj.put(Defines.Jsonkey.PluginName.getKey(), (Object)Branch.getPluginName());
                requestObj.put(Defines.Jsonkey.PluginVersion.getKey(), (Object)Branch.getPluginVersion());
            }
            if (!TextUtils.isEmpty((CharSequence)(countryCode = SystemObserver.getISO2CountryCode()))) {
                requestObj.put(Defines.Jsonkey.Country.getKey(), (Object)countryCode);
            }
            if (!TextUtils.isEmpty((CharSequence)(languageCode = SystemObserver.getISO2LanguageCode()))) {
                requestObj.put(Defines.Jsonkey.Language.getKey(), (Object)languageCode);
            }
            if (!TextUtils.isEmpty((CharSequence)(localIpAddr = SystemObserver.getLocalIPAddress()))) {
                requestObj.put(Defines.Jsonkey.LocalIP.getKey(), (Object)localIpAddr);
            }
            if (serverRequest.isInitializationOrEventRequest()) {
                requestObj.put(Defines.Jsonkey.CPUType.getKey(), (Object)SystemObserver.getCPUType());
                requestObj.put(Defines.Jsonkey.DeviceBuildId.getKey(), (Object)SystemObserver.getDeviceBuildId());
                requestObj.put(Defines.Jsonkey.Locale.getKey(), (Object)SystemObserver.getLocale());
                requestObj.put(Defines.Jsonkey.ConnectionType.getKey(), (Object)SystemObserver.getConnectionType(this.context_));
                requestObj.put(Defines.Jsonkey.DeviceCarrier.getKey(), (Object)SystemObserver.getCarrier(this.context_));
                requestObj.put(Defines.Jsonkey.OSVersionAndroid.getKey(), (Object)SystemObserver.getOSVersion());
            }
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException" + e.getMessage());
        }
    }

    boolean isTV() {
        UiModeManager uiModeManager = (UiModeManager)this.context_.getSystemService("uimode");
        if (uiModeManager == null) {
            BranchLogger.v("uiModeManager is null, mark this as a non-TV device by default.");
            return false;
        }
        return uiModeManager.getCurrentModeType() == 4;
    }

    void updateRequestWithV2Params(ServerRequest serverRequest, PrefHelper prefHelper, JSONObject userDataObj) {
        try {
            String localIpAddr;
            String languageCode;
            String countryCode;
            String modelName;
            String brandName;
            String anonID;
            SystemObserver.UniqueId hardwareID = this.getHardwareID();
            if (!DeviceInfo.isNullOrEmptyOrBlank(hardwareID.getId())) {
                userDataObj.put(Defines.Jsonkey.AndroidID.getKey(), (Object)hardwareID.getId());
            }
            if (!DeviceInfo.isNullOrEmptyOrBlank(anonID = SystemObserver.getAnonID(this.context_))) {
                userDataObj.put(Defines.Jsonkey.AnonID.getKey(), (Object)anonID);
            }
            if (!DeviceInfo.isNullOrEmptyOrBlank(brandName = SystemObserver.getPhoneBrand())) {
                userDataObj.put(Defines.Jsonkey.Brand.getKey(), (Object)brandName);
            }
            if (!DeviceInfo.isNullOrEmptyOrBlank(modelName = SystemObserver.getPhoneModel())) {
                userDataObj.put(Defines.Jsonkey.Model.getKey(), (Object)modelName);
            }
            DisplayMetrics displayMetrics = SystemObserver.getScreenDisplay(this.context_);
            userDataObj.put(Defines.Jsonkey.ScreenDpi.getKey(), displayMetrics.densityDpi);
            userDataObj.put(Defines.Jsonkey.ScreenHeight.getKey(), displayMetrics.heightPixels);
            userDataObj.put(Defines.Jsonkey.ScreenWidth.getKey(), displayMetrics.widthPixels);
            userDataObj.put(Defines.Jsonkey.UIMode.getKey(), (Object)SystemObserver.getUIMode(this.context_));
            String osName = SystemObserver.getOS(this.context_);
            if (!DeviceInfo.isNullOrEmptyOrBlank(osName)) {
                userDataObj.put(Defines.Jsonkey.OS.getKey(), (Object)osName);
            }
            userDataObj.put(Defines.Jsonkey.APILevel.getKey(), SystemObserver.getAPILevel());
            if (Branch.getPluginName() != null) {
                userDataObj.put(Defines.Jsonkey.PluginName.getKey(), (Object)Branch.getPluginName());
                userDataObj.put(Defines.Jsonkey.PluginVersion.getKey(), (Object)Branch.getPluginVersion());
            }
            if (!TextUtils.isEmpty((CharSequence)(countryCode = SystemObserver.getISO2CountryCode()))) {
                userDataObj.put(Defines.Jsonkey.Country.getKey(), (Object)countryCode);
            }
            if (!TextUtils.isEmpty((CharSequence)(languageCode = SystemObserver.getISO2LanguageCode()))) {
                userDataObj.put(Defines.Jsonkey.Language.getKey(), (Object)languageCode);
            }
            if (!TextUtils.isEmpty((CharSequence)(localIpAddr = SystemObserver.getLocalIPAddress()))) {
                userDataObj.put(Defines.Jsonkey.LocalIP.getKey(), (Object)localIpAddr);
            }
            if (prefHelper != null) {
                String appStore;
                String devId;
                if (!DeviceInfo.isNullOrEmptyOrBlank(prefHelper.getRandomizedDeviceToken())) {
                    userDataObj.put(Defines.Jsonkey.RandomizedDeviceToken.getKey(), (Object)prefHelper.getRandomizedDeviceToken());
                }
                if (!DeviceInfo.isNullOrEmptyOrBlank(devId = prefHelper.getIdentity())) {
                    userDataObj.put(Defines.Jsonkey.DeveloperIdentity.getKey(), (Object)devId);
                }
                if (!"bnc_no_value".equals(appStore = prefHelper.getAppStoreSource())) {
                    userDataObj.put(Defines.Jsonkey.App_Store.getKey(), (Object)appStore);
                }
            }
            userDataObj.put(Defines.Jsonkey.AppVersion.getKey(), (Object)this.getAppVersion());
            userDataObj.put(Defines.Jsonkey.SDK.getKey(), (Object)"android");
            userDataObj.put(Defines.Jsonkey.SdkVersion.getKey(), (Object)Branch.getSdkVersionNumber());
            this.setPostUserAgent(userDataObj);
            if (serverRequest instanceof ServerRequestGetLATD) {
                userDataObj.put(Defines.Jsonkey.LATDAttributionWindow.getKey(), ((ServerRequestGetLATD)serverRequest).getAttributionWindow());
            }
            if (serverRequest.isInitializationOrEventRequest()) {
                userDataObj.put(Defines.Jsonkey.CPUType.getKey(), (Object)SystemObserver.getCPUType());
                userDataObj.put(Defines.Jsonkey.DeviceBuildId.getKey(), (Object)SystemObserver.getDeviceBuildId());
                userDataObj.put(Defines.Jsonkey.Locale.getKey(), (Object)SystemObserver.getLocale());
                userDataObj.put(Defines.Jsonkey.ConnectionType.getKey(), (Object)SystemObserver.getConnectionType(this.context_));
                userDataObj.put(Defines.Jsonkey.DeviceCarrier.getKey(), (Object)SystemObserver.getCarrier(this.context_));
                userDataObj.put(Defines.Jsonkey.OSVersionAndroid.getKey(), (Object)SystemObserver.getOSVersion());
            }
        }
        catch (JSONException e) {
            BranchLogger.w("Caught JSONException" + e.getMessage());
        }
    }

    private void setPostUserAgent(final JSONObject userDataObj) {
        BranchLogger.v("setPostUserAgent " + Thread.currentThread().getName());
        try {
            if (!TextUtils.isEmpty((CharSequence)Branch._userAgentString)) {
                BranchLogger.v("userAgent was cached: " + Branch._userAgentString);
                userDataObj.put(Defines.Jsonkey.UserAgent.getKey(), (Object)Branch._userAgentString);
                Branch.getInstance().requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.USER_AGENT_STRING_LOCK);
                Branch.getInstance().requestQueue_.processNextQueueItem("setPostUserAgent");
            } else if (Branch.userAgentSync) {
                BranchLogger.v("Start invoking getUserAgentSync from thread " + Thread.currentThread().getName());
                DeviceSignalsKt.getUserAgentSync(this.context_, (Continuation<? super String>)new Continuation<String>(){

                    @NonNull
                    public CoroutineContext getContext() {
                        return EmptyCoroutineContext.INSTANCE;
                    }

                    public void resumeWith(@NonNull Object o) {
                        if (o != null) {
                            Branch._userAgentString = (String)o;
                            BranchLogger.v("onUserAgentStringFetchFinished getUserAgentSync resumeWith releasing lock");
                            try {
                                userDataObj.put(Defines.Jsonkey.UserAgent.getKey(), (Object)Branch._userAgentString);
                            }
                            catch (JSONException e) {
                                BranchLogger.w("Caught JSONException " + e.getMessage());
                            }
                        }
                        Branch.getInstance().requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.USER_AGENT_STRING_LOCK);
                        Branch.getInstance().requestQueue_.processNextQueueItem("onUserAgentStringFetchFinished");
                    }
                });
            } else {
                DeviceSignalsKt.getUserAgentAsync(this.context_, (Continuation<? super String>)new Continuation<String>(){

                    @NonNull
                    public CoroutineContext getContext() {
                        return EmptyCoroutineContext.INSTANCE;
                    }

                    public void resumeWith(@NonNull Object o) {
                        if (o != null) {
                            Branch._userAgentString = (String)o;
                            BranchLogger.v("onUserAgentStringFetchFinished getUserAgentAsync resumeWith releasing lock");
                            try {
                                userDataObj.put(Defines.Jsonkey.UserAgent.getKey(), (Object)Branch._userAgentString);
                            }
                            catch (JSONException e) {
                                BranchLogger.w("Caught JSONException " + e.getMessage());
                            }
                        }
                        Branch.getInstance().requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.USER_AGENT_STRING_LOCK);
                        Branch.getInstance().requestQueue_.processNextQueueItem("getUserAgentAsync resumeWith");
                    }
                });
            }
        }
        catch (Exception exception) {
            BranchLogger.w("Caught exception trying to set userAgent " + exception.getMessage());
        }
    }

    public String getPackageName() {
        return SystemObserver.getPackageName(this.context_);
    }

    public String getAppVersion() {
        return SystemObserver.getAppVersion(this.context_);
    }

    public long getFirstInstallTime() {
        return SystemObserver.getFirstInstallTime(this.context_);
    }

    public long getLastUpdateTime() {
        return SystemObserver.getLastUpdateTime(this.context_);
    }

    public boolean isPackageInstalled() {
        return SystemObserver.isPackageInstalled(this.context_);
    }

    public SystemObserver.UniqueId getHardwareID() {
        this.getSystemObserver();
        return SystemObserver.getUniqueID(this.context_, Branch.isDeviceIDFetchDisabled());
    }

    public String getOsName() {
        return SystemObserver.getOS(this.context_);
    }

    SystemObserver getSystemObserver() {
        return this.systemObserver_;
    }

    public static boolean isNullOrEmptyOrBlank(String str) {
        return TextUtils.isEmpty((CharSequence)str) || str.equals("bnc_no_value");
    }

    private class SystemObserverInstance
    extends SystemObserver {
    }
}

