/*
 * Decompiled with CFR 0.152.
 */
package io.branch.indexing;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.BranchLogger;
import io.branch.referral.BranchShareSheetBuilder;
import io.branch.referral.BranchShortLinkBuilder;
import io.branch.referral.BranchUtil;
import io.branch.referral.Defines;
import io.branch.referral.TrackingController;
import io.branch.referral.util.BRANCH_STANDARD_EVENT;
import io.branch.referral.util.BranchEvent;
import io.branch.referral.util.ContentMetadata;
import io.branch.referral.util.CurrencyType;
import io.branch.referral.util.LinkProperties;
import io.branch.referral.util.ShareSheetStyle;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchUniversalObject
implements Parcelable {
    private String canonicalIdentifier_ = "";
    private String canonicalUrl_ = "";
    private String title_ = "";
    private String description_ = "";
    private String imageUrl_;
    private ContentMetadata metadata_ = new ContentMetadata();
    private CONTENT_INDEX_MODE indexMode_;
    private final ArrayList<String> keywords_ = new ArrayList();
    private long expirationInMilliSec_ = 0L;
    private CONTENT_INDEX_MODE localIndexMode_;
    private long creationTimeStamp_;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public BranchUniversalObject createFromParcel(Parcel in) {
            return new BranchUniversalObject(in);
        }

        public BranchUniversalObject[] newArray(int size) {
            return new BranchUniversalObject[size];
        }
    };

    public BranchUniversalObject() {
        this.indexMode_ = CONTENT_INDEX_MODE.PUBLIC;
        this.localIndexMode_ = CONTENT_INDEX_MODE.PUBLIC;
        this.creationTimeStamp_ = System.currentTimeMillis();
    }

    public BranchUniversalObject setCanonicalIdentifier(@NonNull String canonicalIdentifier) {
        this.canonicalIdentifier_ = canonicalIdentifier;
        return this;
    }

    public BranchUniversalObject setCanonicalUrl(@NonNull String canonicalUrl) {
        this.canonicalUrl_ = canonicalUrl;
        return this;
    }

    public BranchUniversalObject setTitle(@NonNull String title) {
        this.title_ = title;
        return this;
    }

    public BranchUniversalObject setContentDescription(String description) {
        this.description_ = description;
        return this;
    }

    public BranchUniversalObject setContentImageUrl(@NonNull String imageUrl) {
        this.imageUrl_ = imageUrl;
        return this;
    }

    public BranchUniversalObject addContentMetadata(HashMap<String, String> metadata) {
        if (metadata != null) {
            for (String key : metadata.keySet()) {
                this.metadata_.addCustomMetadata(key, metadata.get(key));
            }
        }
        return this;
    }

    public BranchUniversalObject addContentMetadata(String key, String value) {
        this.metadata_.addCustomMetadata(key, value);
        return this;
    }

    public BranchUniversalObject setContentMetadata(ContentMetadata metadata) {
        this.metadata_ = metadata;
        return this;
    }

    public BranchUniversalObject setContentType(String type) {
        return this;
    }

    public BranchUniversalObject setContentIndexingMode(CONTENT_INDEX_MODE indexMode) {
        this.indexMode_ = indexMode;
        return this;
    }

    public BranchUniversalObject setLocalIndexMode(CONTENT_INDEX_MODE localIndexMode) {
        this.localIndexMode_ = localIndexMode;
        return this;
    }

    public BranchUniversalObject addKeyWords(ArrayList<String> keywords) {
        this.keywords_.addAll(keywords);
        return this;
    }

    public BranchUniversalObject addKeyWord(String keyword) {
        this.keywords_.add(keyword);
        return this;
    }

    public BranchUniversalObject setContentExpiration(Date expirationDate) {
        this.expirationInMilliSec_ = expirationDate.getTime();
        return this;
    }

    public BranchUniversalObject setPrice(double price, CurrencyType currency) {
        return this;
    }

    public boolean isPublicallyIndexable() {
        return this.indexMode_ == CONTENT_INDEX_MODE.PUBLIC;
    }

    public boolean isLocallyIndexable() {
        return this.localIndexMode_ == CONTENT_INDEX_MODE.PUBLIC;
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata_.getCustomMetadata();
    }

    public ContentMetadata getContentMetadata() {
        return this.metadata_;
    }

    public long getExpirationTime() {
        return this.expirationInMilliSec_;
    }

    public String getCanonicalIdentifier() {
        return this.canonicalIdentifier_;
    }

    public String getCanonicalUrl() {
        return this.canonicalUrl_;
    }

    public String getDescription() {
        return this.description_;
    }

    public String getImageUrl() {
        return this.imageUrl_;
    }

    public String getTitle() {
        return this.title_;
    }

    public String getType() {
        return null;
    }

    public double getPrice() {
        return 0.0;
    }

    public String getCurrencyType() {
        return null;
    }

    public JSONArray getKeywordsJsonArray() {
        JSONArray keywordArray = new JSONArray();
        for (String keyword : this.keywords_) {
            keywordArray.put((Object)keyword);
        }
        return keywordArray;
    }

    public ArrayList<String> getKeywords() {
        return this.keywords_;
    }

    public void registerView() {
        this.registerView(null);
    }

    public void registerView(@Nullable RegisterViewStatusListener callback) {
        if (Branch.getInstance() != null) {
            Branch.getInstance().registerView(this, callback);
        } else if (callback != null) {
            callback.onRegisterViewFinished(false, new BranchError("Register view error", -109));
        }
    }

    public String getShortUrl(@NonNull Context context, @NonNull LinkProperties linkProperties) {
        return this.getLinkBuilder(context, linkProperties).getShortUrl();
    }

    public String getShortUrl(@NonNull Context context, @NonNull LinkProperties linkProperties, boolean defaultToLongUrl) {
        return ((BranchShortLinkBuilder)this.getLinkBuilder(context, linkProperties).setDefaultToLongUrl(defaultToLongUrl)).getShortUrl();
    }

    public void generateShortUrl(@NonNull Context context, @NonNull LinkProperties linkProperties, @Nullable Branch.BranchLinkCreateListener callback) {
        if (TrackingController.isTrackingDisabled(context) && callback != null) {
            callback.onLinkCreate(this.getLinkBuilder(context, linkProperties).getShortUrl(), null);
        } else {
            this.getLinkBuilder(context, linkProperties).generateShortUrl(callback);
        }
    }

    public void generateShortUrl(@NonNull Context context, @NonNull LinkProperties linkProperties, @Nullable Branch.BranchLinkCreateListener callback, boolean defaultToLongUrl) {
        ((BranchShortLinkBuilder)this.getLinkBuilder(context, linkProperties).setDefaultToLongUrl(defaultToLongUrl)).generateShortUrl(callback);
    }

    public void showShareSheet(@NonNull Activity activity, @NonNull LinkProperties linkProperties, @NonNull ShareSheetStyle style, @Nullable Branch.BranchLinkShareListener callback) {
        this.showShareSheet(activity, linkProperties, style, callback, null);
    }

    public void showShareSheet(@NonNull Activity activity, @NonNull LinkProperties linkProperties, @NonNull ShareSheetStyle style, @Nullable Branch.BranchLinkShareListener callback, Branch.IChannelProperties channelProperties) {
        if (Branch.getInstance() == null) {
            if (callback != null) {
                callback.onLinkShareResponse(null, null, new BranchError("Trouble sharing link. ", -109));
            } else {
                BranchLogger.v("Sharing error. Branch instance is not created yet. Make sure you have initialised Branch.");
            }
        } else {
            BranchShareSheetBuilder shareLinkBuilder = new BranchShareSheetBuilder(activity, this.getLinkBuilder((Context)activity, linkProperties));
            shareLinkBuilder.setCallback(new LinkShareListenerWrapper(callback, shareLinkBuilder, linkProperties)).setChannelProperties(channelProperties).setSubject(style.getMessageTitle()).setMessage(style.getMessageBody());
            if (style.getCopyUrlIcon() != null) {
                shareLinkBuilder.setCopyUrlStyle(style.getCopyUrlIcon(), style.getCopyURlText(), style.getUrlCopiedMessage());
            }
            if (style.getMoreOptionIcon() != null) {
                shareLinkBuilder.setMoreOptionStyle(style.getMoreOptionIcon(), style.getMoreOptionText());
            }
            if (style.getDefaultURL() != null) {
                shareLinkBuilder.setDefaultURL(style.getDefaultURL());
            }
            if (style.getPreferredOptions().size() > 0) {
                shareLinkBuilder.addPreferredSharingOptions(style.getPreferredOptions());
            }
            if (style.getStyleResourceID() > 0) {
                shareLinkBuilder.setStyleResourceID(style.getStyleResourceID());
            }
            shareLinkBuilder.setDividerHeight(style.getDividerHeight());
            shareLinkBuilder.setAsFullWidthStyle(style.getIsFullWidthStyle());
            shareLinkBuilder.setDialogThemeResourceID(style.getDialogThemeResourceID());
            shareLinkBuilder.setSharingTitle(style.getSharingTitle());
            shareLinkBuilder.setSharingTitle(style.getSharingTitleView());
            shareLinkBuilder.setIconSize(style.getIconSize());
            if (style.getIncludedInShareSheet() != null && style.getIncludedInShareSheet().size() > 0) {
                shareLinkBuilder.includeInShareSheet(style.getIncludedInShareSheet());
            }
            if (style.getExcludedFromShareSheet() != null && style.getExcludedFromShareSheet().size() > 0) {
                shareLinkBuilder.excludeFromShareSheet(style.getExcludedFromShareSheet());
            }
            shareLinkBuilder.shareLink();
        }
    }

    private BranchShortLinkBuilder getLinkBuilder(@NonNull Context context, @NonNull LinkProperties linkProperties) {
        BranchShortLinkBuilder shortLinkBuilder = new BranchShortLinkBuilder(context);
        return this.getLinkBuilder(shortLinkBuilder, linkProperties);
    }

    private BranchShortLinkBuilder getLinkBuilder(@NonNull BranchShortLinkBuilder shortLinkBuilder, @NonNull LinkProperties linkProperties) {
        JSONArray keywords;
        if (linkProperties.getTags() != null) {
            shortLinkBuilder.addTags(linkProperties.getTags());
        }
        if (linkProperties.getFeature() != null) {
            shortLinkBuilder.setFeature(linkProperties.getFeature());
        }
        if (linkProperties.getAlias() != null) {
            shortLinkBuilder.setAlias(linkProperties.getAlias());
        }
        if (linkProperties.getChannel() != null) {
            shortLinkBuilder.setChannel(linkProperties.getChannel());
        }
        if (linkProperties.getStage() != null) {
            shortLinkBuilder.setStage(linkProperties.getStage());
        }
        if (linkProperties.getCampaign() != null) {
            shortLinkBuilder.setCampaign(linkProperties.getCampaign());
        }
        if (linkProperties.getMatchDuration() > 0) {
            shortLinkBuilder.setDuration(linkProperties.getMatchDuration());
        }
        if (!TextUtils.isEmpty((CharSequence)this.title_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentTitle.getKey(), this.title_);
        }
        if (!TextUtils.isEmpty((CharSequence)this.canonicalIdentifier_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.CanonicalIdentifier.getKey(), this.canonicalIdentifier_);
        }
        if (!TextUtils.isEmpty((CharSequence)this.canonicalUrl_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.CanonicalUrl.getKey(), this.canonicalUrl_);
        }
        if ((keywords = this.getKeywordsJsonArray()).length() > 0) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentKeyWords.getKey(), keywords);
        }
        if (!TextUtils.isEmpty((CharSequence)this.description_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentDesc.getKey(), this.description_);
        }
        if (!TextUtils.isEmpty((CharSequence)this.imageUrl_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentImgUrl.getKey(), this.imageUrl_);
        }
        if (this.expirationInMilliSec_ > 0L) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentExpiryTime.getKey(), "" + this.expirationInMilliSec_);
        }
        shortLinkBuilder.addParameters(Defines.Jsonkey.PublicallyIndexable.getKey(), "" + this.isPublicallyIndexable());
        JSONObject metadataJson = this.metadata_.convertToJson();
        try {
            Iterator keys = metadataJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                shortLinkBuilder.addParameters(key, metadataJson.get(key));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        HashMap<String, String> controlParam = linkProperties.getControlParams();
        for (String key : controlParam.keySet()) {
            shortLinkBuilder.addParameters(key, controlParam.get(key));
        }
        return shortLinkBuilder;
    }

    public static BranchUniversalObject getReferredBranchUniversalObject() {
        BranchUniversalObject branchUniversalObject = null;
        Branch branchInstance = Branch.getInstance();
        try {
            if (branchInstance != null && branchInstance.getLatestReferringParams() != null) {
                if (branchInstance.getLatestReferringParams().has("+clicked_branch_link") && branchInstance.getLatestReferringParams().getBoolean("+clicked_branch_link")) {
                    branchUniversalObject = BranchUniversalObject.createInstance(branchInstance.getLatestReferringParams());
                } else if (branchInstance.getDeeplinkDebugParams() != null && branchInstance.getDeeplinkDebugParams().length() > 0) {
                    branchUniversalObject = BranchUniversalObject.createInstance(branchInstance.getLatestReferringParams());
                }
            }
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
        return branchUniversalObject;
    }

    public static BranchUniversalObject createInstance(JSONObject jsonObject) {
        BranchUniversalObject branchUniversalObject = null;
        try {
            Object indexableVal;
            branchUniversalObject = new BranchUniversalObject();
            BranchUtil.JsonReader jsonReader = new BranchUtil.JsonReader(jsonObject);
            branchUniversalObject.title_ = jsonReader.readOutString(Defines.Jsonkey.ContentTitle.getKey());
            branchUniversalObject.canonicalIdentifier_ = jsonReader.readOutString(Defines.Jsonkey.CanonicalIdentifier.getKey());
            branchUniversalObject.canonicalUrl_ = jsonReader.readOutString(Defines.Jsonkey.CanonicalUrl.getKey());
            branchUniversalObject.description_ = jsonReader.readOutString(Defines.Jsonkey.ContentDesc.getKey());
            branchUniversalObject.imageUrl_ = jsonReader.readOutString(Defines.Jsonkey.ContentImgUrl.getKey());
            branchUniversalObject.expirationInMilliSec_ = jsonReader.readOutLong(Defines.Jsonkey.ContentExpiryTime.getKey());
            JSONArray keywordJsonArray = null;
            Object keyWordArrayObject = jsonReader.readOut(Defines.Jsonkey.ContentKeyWords.getKey());
            if (keyWordArrayObject instanceof JSONArray) {
                keywordJsonArray = (JSONArray)keyWordArrayObject;
            } else if (keyWordArrayObject instanceof String) {
                keywordJsonArray = new JSONArray((String)keyWordArrayObject);
            }
            if (keywordJsonArray != null) {
                for (int i = 0; i < keywordJsonArray.length(); ++i) {
                    branchUniversalObject.keywords_.add((String)keywordJsonArray.get(i));
                }
            }
            if ((indexableVal = jsonReader.readOut(Defines.Jsonkey.PublicallyIndexable.getKey())) instanceof Boolean) {
                branchUniversalObject.indexMode_ = (Boolean)indexableVal != false ? CONTENT_INDEX_MODE.PUBLIC : CONTENT_INDEX_MODE.PRIVATE;
            } else if (indexableVal instanceof Integer) {
                branchUniversalObject.indexMode_ = (Integer)indexableVal == 1 ? CONTENT_INDEX_MODE.PUBLIC : CONTENT_INDEX_MODE.PRIVATE;
            }
            branchUniversalObject.localIndexMode_ = jsonReader.readOutBoolean(Defines.Jsonkey.LocallyIndexable.getKey()) ? CONTENT_INDEX_MODE.PUBLIC : CONTENT_INDEX_MODE.PRIVATE;
            branchUniversalObject.creationTimeStamp_ = jsonReader.readOutLong(Defines.Jsonkey.CreationTimestamp.getKey());
            branchUniversalObject.metadata_ = ContentMetadata.createFromJson(jsonReader);
            JSONObject pendingJson = jsonReader.getJsonObject();
            Iterator keys = pendingJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                branchUniversalObject.metadata_.addCustomMetadata(key, pendingJson.optString(key));
            }
        }
        catch (Exception e) {
            BranchLogger.d(e.getMessage());
        }
        return branchUniversalObject;
    }

    public JSONObject convertToJson() {
        JSONObject buoJsonModel = new JSONObject();
        try {
            JSONObject metadataJsonObject = this.metadata_.convertToJson();
            Iterator keys = metadataJsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                buoJsonModel.put(key, metadataJsonObject.get(key));
            }
            if (!TextUtils.isEmpty((CharSequence)this.title_)) {
                buoJsonModel.put(Defines.Jsonkey.ContentTitle.getKey(), (Object)this.title_);
            }
            if (!TextUtils.isEmpty((CharSequence)this.canonicalIdentifier_)) {
                buoJsonModel.put(Defines.Jsonkey.CanonicalIdentifier.getKey(), (Object)this.canonicalIdentifier_);
            }
            if (!TextUtils.isEmpty((CharSequence)this.canonicalUrl_)) {
                buoJsonModel.put(Defines.Jsonkey.CanonicalUrl.getKey(), (Object)this.canonicalUrl_);
            }
            if (this.keywords_.size() > 0) {
                JSONArray keyWordJsonArray = new JSONArray();
                for (String keyword : this.keywords_) {
                    keyWordJsonArray.put((Object)keyword);
                }
                buoJsonModel.put(Defines.Jsonkey.ContentKeyWords.getKey(), (Object)keyWordJsonArray);
            }
            if (!TextUtils.isEmpty((CharSequence)this.description_)) {
                buoJsonModel.put(Defines.Jsonkey.ContentDesc.getKey(), (Object)this.description_);
            }
            if (!TextUtils.isEmpty((CharSequence)this.imageUrl_)) {
                buoJsonModel.put(Defines.Jsonkey.ContentImgUrl.getKey(), (Object)this.imageUrl_);
            }
            if (this.expirationInMilliSec_ > 0L) {
                buoJsonModel.put(Defines.Jsonkey.ContentExpiryTime.getKey(), this.expirationInMilliSec_);
            }
            buoJsonModel.put(Defines.Jsonkey.PublicallyIndexable.getKey(), this.isPublicallyIndexable());
            buoJsonModel.put(Defines.Jsonkey.LocallyIndexable.getKey(), this.isLocallyIndexable());
            buoJsonModel.put(Defines.Jsonkey.CreationTimestamp.getKey(), this.creationTimeStamp_);
        }
        catch (JSONException e) {
            BranchLogger.d(e.getMessage());
        }
        return buoJsonModel;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.creationTimeStamp_);
        dest.writeString(this.canonicalIdentifier_);
        dest.writeString(this.canonicalUrl_);
        dest.writeString(this.title_);
        dest.writeString(this.description_);
        dest.writeString(this.imageUrl_);
        dest.writeLong(this.expirationInMilliSec_);
        dest.writeInt(this.indexMode_.ordinal());
        dest.writeSerializable(this.keywords_);
        dest.writeParcelable((Parcelable)this.metadata_, flags);
        dest.writeInt(this.localIndexMode_.ordinal());
    }

    private BranchUniversalObject(Parcel in) {
        this();
        this.creationTimeStamp_ = in.readLong();
        this.canonicalIdentifier_ = in.readString();
        this.canonicalUrl_ = in.readString();
        this.title_ = in.readString();
        this.description_ = in.readString();
        this.imageUrl_ = in.readString();
        this.expirationInMilliSec_ = in.readLong();
        this.indexMode_ = CONTENT_INDEX_MODE.values()[in.readInt()];
        ArrayList keywordsTemp = (ArrayList)in.readSerializable();
        if (keywordsTemp != null) {
            this.keywords_.addAll(keywordsTemp);
        }
        this.metadata_ = (ContentMetadata)in.readParcelable(ContentMetadata.class.getClassLoader());
        this.localIndexMode_ = CONTENT_INDEX_MODE.values()[in.readInt()];
    }

    public static enum CONTENT_INDEX_MODE {
        PUBLIC,
        PRIVATE;

    }

    public static interface RegisterViewStatusListener {
        public void onRegisterViewFinished(boolean var1, BranchError var2);
    }

    private class LinkShareListenerWrapper
    implements Branch.BranchLinkShareListener {
        private final Branch.BranchLinkShareListener originalCallback_;
        private final BranchShareSheetBuilder shareSheetBuilder_;
        private final LinkProperties linkProperties_;

        LinkShareListenerWrapper(Branch.BranchLinkShareListener originalCallback, BranchShareSheetBuilder shareLinkBuilder, LinkProperties linkProperties) {
            this.originalCallback_ = originalCallback;
            this.shareSheetBuilder_ = shareLinkBuilder;
            this.linkProperties_ = linkProperties;
        }

        @Override
        public void onShareLinkDialogLaunched() {
            if (this.originalCallback_ != null) {
                this.originalCallback_.onShareLinkDialogLaunched();
            }
        }

        @Override
        public void onShareLinkDialogDismissed() {
            if (this.originalCallback_ != null) {
                this.originalCallback_.onShareLinkDialogDismissed();
            }
        }

        @Override
        public void onLinkShareResponse(String sharedLink, String sharedChannel, BranchError error) {
            BranchEvent shareEvent = new BranchEvent(BRANCH_STANDARD_EVENT.SHARE);
            if (error == null) {
                shareEvent.addCustomDataProperty(Defines.Jsonkey.SharedLink.getKey(), sharedLink);
                shareEvent.addCustomDataProperty(Defines.Jsonkey.SharedChannel.getKey(), sharedChannel);
                shareEvent.addContentItems(BranchUniversalObject.this);
            } else {
                shareEvent.addCustomDataProperty(Defines.Jsonkey.ShareError.getKey(), error.getMessage());
            }
            shareEvent.logEvent(Branch.getInstance().getApplicationContext());
            if (this.originalCallback_ != null) {
                this.originalCallback_.onLinkShareResponse(sharedLink, sharedChannel, error);
            }
        }

        @Override
        public void onChannelSelected(String channelName) {
            if (this.originalCallback_ != null) {
                this.originalCallback_.onChannelSelected(channelName);
            }
            if (this.originalCallback_ instanceof Branch.ExtendedBranchLinkShareListener && ((Branch.ExtendedBranchLinkShareListener)this.originalCallback_).onChannelSelected(channelName, BranchUniversalObject.this, this.linkProperties_)) {
                this.shareSheetBuilder_.setShortLinkBuilderInternal(BranchUniversalObject.this.getLinkBuilder(this.shareSheetBuilder_.getShortLinkBuilder(), this.linkProperties_));
            }
        }
    }
}

