/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.adapter;

import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.adapter.NativeFileContext;
import io.bit3.jsass.adapter.NativeImporterWrapper;
import io.bit3.jsass.adapter.NativeLoader;
import io.bit3.jsass.adapter.NativeOptions;
import io.bit3.jsass.adapter.NativeStringContext;
import io.bit3.jsass.context.Context;
import io.bit3.jsass.context.FileContext;
import io.bit3.jsass.context.ImportStack;
import io.bit3.jsass.context.StringContext;
import io.bit3.jsass.function.FunctionWrapper;
import io.bit3.jsass.function.FunctionWrapperFactory;
import io.bit3.jsass.function.JsassCustomFunctions;
import io.bit3.jsass.importer.Importer;
import io.bit3.jsass.importer.JsassCustomHeaderImporter;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NativeAdapter {
    private final FunctionWrapperFactory functionWrapperFactory;

    public NativeAdapter(FunctionWrapperFactory functionWrapperFactory) {
        this.functionWrapperFactory = functionWrapperFactory;
    }

    public Output compile(FileContext context, ImportStack importStack) throws CompilationException {
        NativeFileContext nativeContext = this.convertToNativeContext(context, importStack);
        return NativeAdapter.compileFile(nativeContext);
    }

    public Output compile(StringContext context, ImportStack importStack) throws CompilationException {
        NativeStringContext nativeContext = this.convertToNativeContext(context, importStack);
        return NativeAdapter.compileString(nativeContext);
    }

    private NativeFileContext convertToNativeContext(FileContext context, ImportStack importStack) {
        String inputPath = NativeAdapter.convertToString(context.getInputPath());
        String outputPath = NativeAdapter.convertToString(context.getOutputPath());
        NativeOptions options = this.convertToNativeOptions(context, importStack);
        return new NativeFileContext(inputPath, outputPath, options);
    }

    private NativeStringContext convertToNativeContext(StringContext context, ImportStack importStack) {
        String source = context.getString();
        String inputPath = NativeAdapter.convertToString(context.getInputPath());
        String outputPath = NativeAdapter.convertToString(context.getOutputPath());
        NativeOptions options = this.convertToNativeOptions(context, importStack);
        return new NativeStringContext(source, inputPath, outputPath, options);
    }

    private static String convertToString(URI uri) {
        if (null == uri) {
            return "";
        }
        String string = uri.toString();
        if ("file".equals(uri.getScheme())) {
            string = new File(uri).getAbsolutePath();
        }
        return string;
    }

    private NativeOptions convertToNativeOptions(Context context, ImportStack importStack) {
        Options options = context.getOptions();
        FunctionWrapper[] functionWrappers = this.getFunctionWrappers(context, importStack, options);
        NativeImporterWrapper[] headerImporters = NativeAdapter.getHeaderImporters(importStack, options);
        NativeImporterWrapper[] importers = NativeAdapter.getImporters(importStack, options);
        List<File> includePathsList = options.getIncludePaths();
        String includePath = includePathsList.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        String indent = options.getIndent();
        boolean isIndentedSyntaxSrc = options.isIndentedSyntaxSrc();
        String linefeed = options.getLinefeed();
        boolean omitSourceMapUrl = options.isOmitSourceMapUrl();
        int outputStyle = options.getOutputStyle().numeric;
        String pluginPath = options.getPluginPath();
        int precision = options.getPrecision();
        boolean sourceComments = options.isSourceComments();
        boolean sourceMapContents = options.isSourceMapContents();
        boolean sourceMapEmbed = options.isSourceMapEmbed();
        String sourceMapFile = NativeAdapter.convertToString(options.getSourceMapFile());
        String sourceMapRoot = NativeAdapter.convertToString(options.getSourceMapRoot());
        return new NativeOptions(functionWrappers, headerImporters, importers, includePath, indent, isIndentedSyntaxSrc, linefeed, omitSourceMapUrl, outputStyle, pluginPath, precision, sourceComments, sourceMapContents, sourceMapEmbed, sourceMapFile, sourceMapRoot);
    }

    private FunctionWrapper[] getFunctionWrappers(Context context, ImportStack importStack, Options options) {
        List<FunctionWrapper> functionWrappersList;
        try (Stream functionWrappersStream = Stream.concat(this.functionWrapperFactory.compileFunctions(importStack, context, new JsassCustomFunctions(importStack)).stream(), this.functionWrapperFactory.compileFunctions(importStack, context, options.getFunctionProviders()).stream());){
            functionWrappersList = functionWrappersStream.collect(Collectors.toList());
        }
        return functionWrappersList.toArray(new FunctionWrapper[functionWrappersList.size()]);
    }

    private static NativeImporterWrapper[] getHeaderImporters(ImportStack importStack, Options options) {
        NativeImporterWrapper[] headerImporters;
        List<Importer> headerImportersList = options.getHeaderImporters();
        try (Stream<JsassCustomHeaderImporter> headerImportersStream = Stream.concat(Stream.of(new JsassCustomHeaderImporter(importStack)), headerImportersList.stream());){
            headerImporters = headerImportersStream.map(i -> new NativeImporterWrapper(importStack, (Importer)i)).collect(Collectors.toList()).toArray(new NativeImporterWrapper[headerImportersList.size()]);
        }
        return headerImporters;
    }

    private static NativeImporterWrapper[] getImporters(ImportStack importStack, Options options) {
        Collection<Importer> importersList = options.getImporters();
        return importersList.stream().map(i -> new NativeImporterWrapper(importStack, (Importer)i)).collect(Collectors.toList()).toArray(new NativeImporterWrapper[importersList.size()]);
    }

    private static native Output compileFile(NativeFileContext var0) throws CompilationException;

    private static native Output compileString(NativeStringContext var0) throws CompilationException;

    public static native String sass2scss(String var0, int var1);

    public static native String libsassVersion();

    static {
        NativeLoader.loadLibrary();
    }
}

