/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector;

import io.axoniq.axonserver.connector.AxonServerConnection;
import io.axoniq.axonserver.connector.impl.AxonConnectorThreadFactory;
import io.axoniq.axonserver.connector.impl.AxonServerManagedChannel;
import io.axoniq.axonserver.connector.impl.ContextConnection;
import io.axoniq.axonserver.connector.impl.GrpcBufferingInterceptor;
import io.axoniq.axonserver.connector.impl.HeaderAttachingInterceptor;
import io.axoniq.axonserver.connector.impl.Headers;
import io.axoniq.axonserver.connector.impl.ObjectUtils;
import io.axoniq.axonserver.connector.impl.ReconnectConfiguration;
import io.axoniq.axonserver.connector.impl.ServerAddress;
import io.axoniq.axonserver.grpc.control.ClientIdentification;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonServerConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(AxonServerConnectionFactory.class);
    private static final String CONNECTOR_VERSION = "4.4";
    private final Map<String, String> tags = new HashMap<String, String>();
    private final String componentName;
    private final String clientInstanceId;
    private final Map<String, ContextConnection> connections = new ConcurrentHashMap<String, ContextConnection>();
    private final List<ServerAddress> routingServers;
    private final String token;
    private final ScheduledExecutorService executorService;
    private final Function<NettyChannelBuilder, ManagedChannelBuilder<?>> connectionConfig;
    private final boolean suppressDownloadMessage;
    private final ReconnectConfiguration reconnectConfiguration;
    private final long processorInfoUpdateFrequency;
    private final int commandPermits;
    private final int queryPermits;
    private volatile boolean shutdown;

    protected AxonServerConnectionFactory(Builder builder) {
        this.componentName = builder.componentName;
        this.clientInstanceId = builder.clientInstanceId;
        this.token = builder.token;
        this.tags.putAll(builder.tags);
        this.executorService = builder.executorService;
        this.suppressDownloadMessage = builder.suppressDownloadMessage;
        this.routingServers = builder.routingServers;
        this.connectionConfig = builder.sslConfig.andThen(builder.keepAliveConfig).andThen(builder.otherConfig);
        this.reconnectConfiguration = new ReconnectConfiguration(builder.connectTimeout, builder.reconnectInterval, builder.forceReconnectViaRoutingServers, TimeUnit.MILLISECONDS);
        this.processorInfoUpdateFrequency = builder.processorInfoUpdateFrequency;
        this.commandPermits = builder.commandPermits;
        this.queryPermits = builder.queryPermits;
    }

    public static Builder forClient(String componentName) {
        return AxonServerConnectionFactory.forClient(componentName, componentName + "_" + ObjectUtils.randomHex(8));
    }

    public static Builder forClient(String componentName, String clientInstanceId) {
        return new Builder(componentName, clientInstanceId);
    }

    public AxonServerConnection connect(String context) {
        if (this.shutdown) {
            throw new IllegalStateException("Connector is already shut down");
        }
        ContextConnection contextConnection = this.connections.computeIfAbsent(context, this::createConnection);
        contextConnection.connect();
        return contextConnection;
    }

    private ContextConnection createConnection(String context) {
        ClientIdentification clientIdentification = ClientIdentification.newBuilder().setClientId(this.clientInstanceId).setComponentName(this.componentName).putAllTags(this.tags).setVersion(CONNECTOR_VERSION).build();
        return new ContextConnection(clientIdentification, this.executorService, new AxonServerManagedChannel(this.routingServers, this.reconnectConfiguration, context, clientIdentification, this.executorService, this::createChannel), this.processorInfoUpdateFrequency, this.commandPermits, this.queryPermits, context, cnx -> this.connections.remove(context, cnx));
    }

    private ManagedChannel createChannel(ServerAddress address, String context) {
        ManagedChannelBuilder<?> builder = this.connectionConfig.apply(NettyChannelBuilder.forAddress((String)address.getHostName(), (int)address.getGrpcPort()));
        if (!this.suppressDownloadMessage) {
            builder.intercept(new ClientInterceptor[]{new DownloadInstructionInterceptor(System.out)});
        }
        return builder.intercept(new ClientInterceptor[]{new GrpcBufferingInterceptor(50), new HeaderAttachingInterceptor<String>(Headers.CONTEXT, context), new HeaderAttachingInterceptor<String>(Headers.ACCESS_TOKEN, this.token)}).build();
    }

    public void shutdown() {
        this.shutdown = true;
        this.connections.forEach((k, conn) -> conn.disconnect());
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.executorService.isTerminated()) {
            logger.warn("Forcefully shutting down executor service.");
            this.executorService.shutdownNow();
        }
    }

    private static class DownloadInstructionInterceptor
    implements ClientInterceptor {
        private final OutputStream out;
        private volatile boolean suppressDownloadMessage = false;

        public DownloadInstructionInterceptor(OutputStream out) {
            this.out = out;
        }

        public <REQ, RESP> ClientCall<REQ, RESP> interceptCall(MethodDescriptor<REQ, RESP> method, CallOptions callOptions, Channel next) {
            if (!this.suppressDownloadMessage && "io.axoniq.axonserver.grpc.control.PlatformService/GetPlatformServer".equals(method.getFullMethodName())) {
                return new ForwardingClientCall.SimpleForwardingClientCall<REQ, RESP>(next.newCall(method, callOptions)){

                    public void start(ClientCall.Listener<RESP> responseListener, Metadata headers) {
                        super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RESP>(responseListener){

                            public void onClose(Status status, Metadata trailers) {
                                if (status.getCode() == Status.Code.UNAVAILABLE) {
                                    this.writeDownloadMessage();
                                }
                                super.onClose(status, trailers);
                            }
                        }, headers);
                    }
                };
            }
            return next.newCall(method, callOptions);
        }

        private synchronized void writeDownloadMessage() {
            if (!this.suppressDownloadMessage) {
                this.suppressDownloadMessage = true;
                try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("axonserver_download.txt");){
                    int read;
                    byte[] buffer = new byte[1024];
                    while (in != null && (read = in.read(buffer, 0, 1024)) >= 0) {
                        this.out.write(buffer, 0, read);
                    }
                }
                catch (IOException e) {
                    logger.debug("Unable to write download advice. You're on your own now.", (Throwable)e);
                }
            } else {
                this.suppressDownloadMessage = true;
            }
        }
    }

    public static class Builder {
        private final String componentName;
        private final String clientInstanceId;
        private final Map<String, String> tags = new HashMap<String, String>();
        private int queryPermits = 5000;
        private int commandPermits = 5000;
        private long processorInfoUpdateFrequency = 2000L;
        private List<ServerAddress> routingServers;
        private long connectTimeout = 10000L;
        private String token;
        private boolean suppressDownloadMessage = false;
        private ScheduledExecutorService executorService;
        private Function<NettyChannelBuilder, NettyChannelBuilder> sslConfig = NettyChannelBuilder::usePlaintext;
        private Function<NettyChannelBuilder, NettyChannelBuilder> keepAliveConfig = UnaryOperator.identity();
        private Function<ManagedChannelBuilder<?>, ManagedChannelBuilder<?>> otherConfig = UnaryOperator.identity();
        private boolean forceReconnectViaRoutingServers = true;
        private long reconnectInterval = 2000L;
        private int executorPoolSize = 2;

        protected Builder(String componentName, String clientInstanceId) {
            this.componentName = componentName;
            this.clientInstanceId = clientInstanceId;
        }

        public Builder routingServers(ServerAddress ... serverAddresses) {
            this.suppressDownloadMessage = true;
            this.routingServers = new ArrayList<ServerAddress>(Arrays.asList(serverAddresses));
            return this;
        }

        public Builder reconnectInterval(long interval, TimeUnit timeUnit) {
            this.reconnectInterval = timeUnit.toMillis(interval);
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit timeUnit) {
            this.connectTimeout = timeUnit.toMillis(timeout);
            return this;
        }

        public Builder clientTags(Map<String, String> additionalClientTags) {
            this.tags.putAll(additionalClientTags);
            return this;
        }

        public Builder clientTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder useTransportSecurity() {
            this.sslConfig = NettyChannelBuilder::useTransportSecurity;
            return this;
        }

        public Builder useTransportSecurity(SslContext sslContext) {
            this.sslConfig = cb -> cb.sslContext(sslContext);
            return this;
        }

        public Builder forceReconnectViaRoutingServers(boolean forceReconnectViaRoutingServers) {
            this.forceReconnectViaRoutingServers = forceReconnectViaRoutingServers;
            return this;
        }

        public Builder threadPoolSize(int poolSize) {
            this.executorPoolSize = poolSize;
            return this;
        }

        public Builder usingKeepAlive(long interval, long timeout, TimeUnit timeUnit, boolean keepAliveWithoutCalls) {
            this.keepAliveConfig = cb -> cb.keepAliveTime(interval, timeUnit).keepAliveTimeout(timeout, timeUnit).keepAliveWithoutCalls(keepAliveWithoutCalls);
            return this;
        }

        public Builder maxInboundMessageSize(int bytes) {
            this.otherConfig = this.otherConfig.andThen(cb -> cb.maxInboundMessageSize(bytes));
            return this;
        }

        public Builder customize(UnaryOperator<ManagedChannelBuilder<?>> customization) {
            this.otherConfig = this.otherConfig.andThen(customization);
            return this;
        }

        public Builder processorInfoUpdateFrequency(long interval, TimeUnit unit) {
            this.processorInfoUpdateFrequency = unit.toMillis(interval);
            return this;
        }

        public Builder queryPermits(int permits) {
            this.queryPermits = Math.max(16, permits);
            return this;
        }

        public Builder commandPermits(int permits) {
            this.commandPermits = Math.max(16, permits);
            return this;
        }

        protected void validate() {
            if (this.routingServers == null) {
                this.routingServers = Collections.singletonList(new ServerAddress());
            }
            if (this.executorService == null) {
                this.executorService = new ScheduledThreadPoolExecutor(this.executorPoolSize, AxonConnectorThreadFactory.forInstanceId(this.clientInstanceId));
            }
        }

        public AxonServerConnectionFactory build() {
            this.validate();
            return new AxonServerConnectionFactory(this);
        }
    }
}

