/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.axoniq.axonserver.connector.ReplyChannel;
import io.axoniq.axonserver.connector.impl.HeartbeatSender;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import java.time.Clock;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatMonitor {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatMonitor.class);
    private static final PlatformInboundInstruction HEARTBEAT_MESSAGE = PlatformInboundInstruction.newBuilder().setHeartbeat(Heartbeat.getDefaultInstance()).build();
    static Clock clock = Clock.systemUTC();
    private final ScheduledExecutorService executor;
    private final HeartbeatSender sender;
    private final Runnable onHeartbeatMissed;
    private final AtomicLong nextHeartbeatTimeout = new AtomicLong();
    private final AtomicLong nextHeartbeat = new AtomicLong();
    private final AtomicLong timeout = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong interval = new AtomicLong(Long.MAX_VALUE);
    private final AtomicInteger taskId = new AtomicInteger();

    public HeartbeatMonitor(ScheduledExecutorService executor, HeartbeatSender heartbeatSender, Runnable onHeartbeatMissed) {
        this.executor = executor;
        this.sender = heartbeatSender;
        this.onHeartbeatMissed = onHeartbeatMissed;
    }

    public void enableHeartbeat(long interval, long timeout, TimeUnit timeUnit) {
        this.interval.set(timeUnit.toMillis(interval));
        this.timeout.set(timeUnit.toMillis(timeout));
        long now = clock.millis();
        this.nextHeartbeat.set(now);
        this.nextHeartbeatTimeout.set(now + timeUnit.toMillis(timeout));
        int task = this.taskId.incrementAndGet();
        this.executor.execute(() -> this.checkAndReschedule(task));
    }

    public void disableHeartbeat() {
        this.interval.set(Long.MAX_VALUE);
        this.nextHeartbeatTimeout.set(Long.MAX_VALUE);
        this.taskId.incrementAndGet();
    }

    public void checkAndReschedule(int task) {
        if (task == this.taskId.get()) {
            this.checkBeat();
            long delay = Math.min(this.interval.get(), 500L);
            logger.debug("Heartbeat status checked. Scheduling next heartbeat verification in {}ms", (Object)delay);
            this.executor.schedule(() -> this.checkAndReschedule(task), delay, TimeUnit.MILLISECONDS);
        }
    }

    public void pause() {
        long currentInterval = this.interval.get();
        long currentTimeout = this.timeout.get();
        if (currentInterval != Long.MAX_VALUE || currentTimeout != Long.MAX_VALUE) {
            this.taskId.incrementAndGet();
        }
    }

    public void resume() {
        long currentInterval = this.interval.get();
        long currentTimeout = this.timeout.get();
        if (currentInterval != Long.MAX_VALUE && currentTimeout != Long.MAX_VALUE) {
            this.enableHeartbeat(currentInterval, currentTimeout, TimeUnit.MILLISECONDS);
        }
    }

    public void checkBeat() {
        long now = clock.millis();
        long nextTimeout = this.nextHeartbeatTimeout.get();
        if (nextTimeout <= now) {
            logger.info("Did not receive heartbeat acknowledgement within {}ms", (Object)this.timeout.get());
            this.onHeartbeatMissed.run();
            this.nextHeartbeatTimeout.compareAndSet(nextTimeout, now + this.interval.get());
        }
        if (this.planNextBeat(now, this.interval.get())) {
            this.sender.sendHeartbeat().whenComplete((r, e) -> {
                if (e == null) {
                    long currentInterval = this.interval.get();
                    if (currentInterval != Long.MAX_VALUE) {
                        this.nextHeartbeatTimeout.updateAndGet(currentTimeout -> Math.max(nextTimeout + currentInterval, currentTimeout));
                        logger.debug("Heartbeat Acknowledgement received. Extending timeout with {}ms", (Object)currentInterval);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Heartbeat Acknowledgment received.");
                    }
                }
            });
        }
    }

    private boolean planNextBeat(long currentTime, long interval) {
        return this.nextHeartbeat.getAndAccumulate(interval, (next, currentInterval) -> next <= currentTime ? currentTime + currentInterval : next) <= currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIncomingBeat(ReplyChannel<PlatformInboundInstruction> reply) {
        long now = clock.millis();
        long currentInterval = this.interval.get();
        this.planNextBeat(now, currentInterval);
        this.nextHeartbeatTimeout.updateAndGet(current -> Math.max(now + currentInterval, current));
        try {
            reply.send(HEARTBEAT_MESSAGE);
        }
        finally {
            reply.complete();
        }
    }
}

