/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class AxonConnectorThreadFactory
implements ThreadFactory {
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadNumber = new AtomicInteger();

    private AxonConnectorThreadFactory(String instanceId) {
        this.threadGroup = new ThreadGroup("axon-connector-" + instanceId);
    }

    public static AxonConnectorThreadFactory forInstanceId(String instanceId) {
        return new AxonConnectorThreadFactory(instanceId);
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(this.threadGroup, r, this.threadGroup.getName() + "-" + this.nextThreadNumber());
    }

    private int nextThreadNumber() {
        return this.threadNumber.getAndIncrement();
    }
}

