/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.event.impl;

import io.axoniq.axonserver.connector.event.EventStream;
import io.axoniq.axonserver.connector.impl.AbstractBufferedStream;
import io.axoniq.axonserver.connector.impl.ObjectUtils;
import io.axoniq.axonserver.grpc.FlowControl;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.grpc.event.PayloadDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedEventStream
extends AbstractBufferedStream<EventWithToken, GetEventsRequest>
implements EventStream {
    private static final Logger logger = LoggerFactory.getLogger(BufferedEventStream.class);
    private static final EventWithToken TERMINAL_MESSAGE = EventWithToken.newBuilder().setToken(-1729L).build();
    private final long trackingToken;
    private final boolean forceReadFromLeader;

    public BufferedEventStream(long trackingToken, int bufferSize, int refillBatch, boolean forceReadFromLeader) {
        super("unused", bufferSize, refillBatch);
        this.trackingToken = trackingToken;
        this.forceReadFromLeader = forceReadFromLeader;
    }

    @Override
    protected GetEventsRequest buildFlowControlMessage(FlowControl flowControl) {
        GetEventsRequest request = GetEventsRequest.newBuilder().setNumberOfPermits(flowControl.getPermits()).build();
        logger.trace("Sending request for data: {}", (Object)request);
        return request;
    }

    @Override
    protected GetEventsRequest buildInitialFlowControlMessage(FlowControl flowControl) {
        GetEventsRequest eventsRequest = GetEventsRequest.newBuilder().setTrackingToken(this.trackingToken + 1L).setForceReadFromLeader(this.forceReadFromLeader).setNumberOfPermits(flowControl.getPermits()).build();
        logger.trace("Sending request for data: {}", (Object)eventsRequest);
        return eventsRequest;
    }

    @Override
    protected EventWithToken terminalMessage() {
        return TERMINAL_MESSAGE;
    }

    @Override
    public void excludePayloadType(String payloadType, String revision) {
        GetEventsRequest request = GetEventsRequest.newBuilder().addBlacklist(PayloadDescription.newBuilder().setType(payloadType).setRevision(ObjectUtils.nonNullOrDefault(revision, "")).build()).build();
        logger.trace("Requesting exclusion of message type: {}", (Object)request);
        this.outboundStream().onNext((Object)request);
    }
}

