/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.event;

import io.axoniq.axonserver.connector.event.AggregateEventStream;
import io.axoniq.axonserver.connector.event.AppendEventsTransaction;
import io.axoniq.axonserver.connector.event.EventStream;
import io.axoniq.axonserver.grpc.event.Confirmation;
import io.axoniq.axonserver.grpc.event.Event;
import java.util.concurrent.CompletableFuture;

public interface EventChannel {
    public AppendEventsTransaction startAppendEventsTransaction();

    default public CompletableFuture<Confirmation> appendEvents(Event ... events) {
        AppendEventsTransaction tx = this.startAppendEventsTransaction();
        for (Event event : events) {
            tx.appendEvent(event);
        }
        return tx.commit();
    }

    public CompletableFuture<Long> findHighestSequence(String var1);

    default public EventStream openStream(long token, int bufferSize) {
        return this.openStream(token, bufferSize, Math.max(bufferSize >> 3, 16));
    }

    default public EventStream openStream(long token, int bufferSize, int refillBatch) {
        return this.openStream(token, bufferSize, refillBatch, false);
    }

    public EventStream openStream(long var1, int var3, int var4, boolean var5);

    default public AggregateEventStream openAggregateStream(String aggregateIdentifier) {
        return this.openAggregateStream(aggregateIdentifier, true);
    }

    public AggregateEventStream openAggregateStream(String var1, boolean var2);

    default public AggregateEventStream openAggregateStream(String aggregateIdentifier, long initialSequence) {
        return this.openAggregateStream(aggregateIdentifier, initialSequence, 0L);
    }

    public AggregateEventStream openAggregateStream(String var1, long var2, long var4);

    public CompletableFuture<Confirmation> appendSnapshot(Event var1);

    public AggregateEventStream loadSnapshots(String var1, long var2, long var4, int var6);

    default public AggregateEventStream loadSnapshots(String aggregateIdentifier, long maxSequence, int maxResults) {
        return this.loadSnapshots(aggregateIdentifier, 0L, maxSequence, maxResults);
    }

    default public AggregateEventStream loadSnapshot(String aggregateIdentifier) {
        return this.loadSnapshots(aggregateIdentifier, 0L, Long.MAX_VALUE, 1);
    }

    public CompletableFuture<Long> getLastToken();

    public CompletableFuture<Long> getFirstToken();

    public CompletableFuture<Long> getTokenAt(long var1);
}

