/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.event;

import io.axoniq.axonserver.connector.impl.AssertUtils;
import java.util.List;

public class PersistentStreamProperties {
    public static final String HEAD_POSITION = "HEAD";
    public static final String TAIL_POSITION = "TAIL";
    private final String streamName;
    private final int segments;
    private final String sequencingPolicyName;
    private final List<String> sequencingPolicyParameters;
    private final String initialPosition;
    private final String filter;

    public PersistentStreamProperties(String streamName, int segments, String sequencingPolicyName, List<String> sequencingPolicyParameters, String initialPosition, String filter) {
        AssertUtils.assertParameter(segments > 0, "Segments must be > 0");
        AssertUtils.assertParameter(this.valid(initialPosition), "initialPosition must be >= 0 or 'HEAD' or 'TAIL'");
        AssertUtils.assertParameter(sequencingPolicyName != null, "sequencingPolicyName must not be null");
        this.streamName = streamName;
        this.segments = segments;
        this.sequencingPolicyName = sequencingPolicyName;
        this.sequencingPolicyParameters = sequencingPolicyParameters;
        this.initialPosition = initialPosition;
        this.filter = filter;
    }

    private boolean valid(String initialPosition) {
        if (HEAD_POSITION.equals(initialPosition) || TAIL_POSITION.equals(initialPosition)) {
            return true;
        }
        try {
            long initial = Long.parseLong(initialPosition);
            return initial >= 0L;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public String streamName() {
        return this.streamName;
    }

    public int segments() {
        return this.segments;
    }

    public String sequencingPolicyName() {
        return this.sequencingPolicyName;
    }

    public List<String> sequencingPolicyParameters() {
        return this.sequencingPolicyParameters;
    }

    public String initialPosition() {
        return this.initialPosition;
    }

    public String filter() {
        return this.filter;
    }
}

