/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.resolver;

import io.awspring.cloud.sqs.support.converter.SnsNotification;
import io.awspring.cloud.sqs.support.converter.SnsNotificationConverter;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import tools.jackson.databind.json.JsonMapper;

public class SnsNotificationArgumentResolver
implements HandlerMethodArgumentResolver {
    private final SmartMessageConverter converter;

    public SnsNotificationArgumentResolver(MessageConverter converter, JsonMapper jsonMapper) {
        this.converter = new SnsNotificationConverter(converter, jsonMapper);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return SnsNotification.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) {
        return this.converter.fromMessage(message, parameter.getParameterType(), (Object)parameter);
    }
}

