/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.observation;

import io.awspring.cloud.sqs.operations.SendResult;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import io.micrometer.observation.transport.SenderContext;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractTemplateObservation {

    public static interface Specifics<ContextType extends Context> {
        public ContextType createContext(Message<?> var1, String var2);

        public ObservationConvention<ContextType> getDefaultConvention();

        public ObservationDocumentation getDocumentation();
    }

    public static abstract class Context
    extends SenderContext<Map<String, Object>> {
        private static final String BAGGAGE_KEY = "baggage";
        private static final String TRACEPARENT_KEY = "traceparent";
        private static final String TRACESTATE_KEY = "tracestate";
        private static final String B3_KEY = "b3";
        private final Message<?> message;
        private final String destinationName;
        private SendResult<?> sendResult;

        protected Context(Message<?> message, String destinationName) {
            super((carrier, key, value) -> {
                if (carrier != null && Context.isAllowedKey(key)) {
                    carrier.put(key, value);
                }
            });
            this.setCarrier(new HashMap());
            Assert.notNull(message, (String)"Message must not be null");
            Assert.notNull((Object)destinationName, (String)"destinationName must not be null");
            this.message = message;
            this.destinationName = destinationName;
        }

        private static boolean isAllowedKey(String key) {
            return BAGGAGE_KEY.equals(key) || TRACEPARENT_KEY.equals(key) || TRACESTATE_KEY.equals(key) || B3_KEY.equals(key);
        }

        public void setSendResult(SendResult<?> sendResult) {
            Assert.notNull(sendResult, (String)"sendResult must not be null");
            this.sendResult = sendResult;
        }

        public String getMessageId() {
            return this.sendResult != null ? this.sendResult.messageId().toString() : null;
        }

        public SendResult<?> getSendResult() {
            return this.sendResult;
        }

        public Message<?> getMessage() {
            return this.message;
        }

        public String getDestinationName() {
            return this.destinationName;
        }
    }

    public static abstract class Documentation
    implements ObservationDocumentation {
        KeyName[] EMPTY = new KeyName[0];

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return this.getSpecificDefaultConvention();
        }

        protected abstract Class<? extends ObservationConvention<? extends Observation.Context>> getSpecificDefaultConvention();

        public @NonNull KeyName[] getLowCardinalityKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{LowCardinalityTags.values(), this.getSpecificLowCardinalityKeyNames()});
        }

        protected KeyName[] getSpecificLowCardinalityKeyNames() {
            return this.EMPTY;
        }

        public @NonNull KeyName[] getHighCardinalityKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{LowCardinalityTags.values(), this.getSpecificHighCardinalityKeyNames()});
        }

        protected KeyName[] getSpecificHighCardinalityKeyNames() {
            return this.EMPTY;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum LowCardinalityTags implements KeyName
        {
            MESSAGING_SYSTEM{

                public @NonNull String asString() {
                    return "messaging.system";
                }
            }
            ,
            MESSAGING_OPERATION{

                public @NonNull String asString() {
                    return "messaging.operation";
                }
            }
            ,
            MESSAGING_DESTINATION_NAME{

                public @NonNull String asString() {
                    return "messaging.destination.name";
                }
            }
            ,
            MESSAGING_DESTINATION_KIND{

                public @NonNull String asString() {
                    return "messaging.destination.kind";
                }
            };

        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum HighCardinalityTags implements KeyName
        {
            MESSAGE_ID{

                public @NonNull String asString() {
                    return "messaging.message.id";
                }
            };

        }
    }

    public static abstract class Convention<ContextType extends Context>
    implements ObservationConvention<ContextType> {
        public @NonNull KeyValues getLowCardinalityKeyValues(ContextType context) {
            return KeyValues.of((KeyValue[])new KeyValue[]{Documentation.LowCardinalityTags.MESSAGING_SYSTEM.withValue(this.getMessagingSystem()), Documentation.LowCardinalityTags.MESSAGING_OPERATION.withValue("publish"), Documentation.LowCardinalityTags.MESSAGING_DESTINATION_NAME.withValue(((Context)((Object)context)).getDestinationName()), Documentation.LowCardinalityTags.MESSAGING_DESTINATION_KIND.withValue(this.getSourceKind())}).and((Iterable)this.getSpecificLowCardinalityKeyValues(context)).and((Iterable)this.getCustomLowCardinalityKeyValues(context));
        }

        protected KeyValues getSpecificLowCardinalityKeyValues(ContextType context) {
            return KeyValues.empty();
        }

        protected KeyValues getCustomLowCardinalityKeyValues(ContextType context) {
            return KeyValues.empty();
        }

        public @NonNull KeyValues getHighCardinalityKeyValues(@NonNull ContextType context) {
            return this.getMessageIdKeyValue(context).and((Iterable)this.getSpecificHighCardinalityKeyValues(context)).and((Iterable)this.getCustomHighCardinalityKeyValues(context));
        }

        private KeyValues getMessageIdKeyValue(ContextType context) {
            String messageId = ((Context)((Object)context)).getMessageId();
            return messageId != null ? KeyValues.of((KeyValue[])new KeyValue[]{Documentation.HighCardinalityTags.MESSAGE_ID.withValue(messageId)}) : KeyValues.empty();
        }

        protected KeyValues getSpecificHighCardinalityKeyValues(ContextType context) {
            return KeyValues.empty();
        }

        protected KeyValues getCustomHighCardinalityKeyValues(ContextType context) {
            return KeyValues.empty();
        }

        public String getContextualName(ContextType context) {
            return ((Context)((Object)context)).getDestinationName() + " send";
        }

        public String getName() {
            return "spring.aws." + this.getMessagingSystem() + ".template";
        }

        protected abstract String getSourceKind();

        protected abstract String getMessagingSystem();
    }
}

