/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter.legacy;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.sqs.config.legacy.LegacyJackson2MessageConverterFactory;
import io.awspring.cloud.sqs.support.converter.AbstractMessagingMessageConverter;
import io.awspring.cloud.sqs.support.converter.HeaderMapper;
import io.awspring.cloud.sqs.support.converter.MessageConversionContext;
import io.awspring.cloud.sqs.support.converter.SimpleClassMatchingMessageConverter;
import io.awspring.cloud.sqs.support.converter.SqsHeaderMapper;
import io.awspring.cloud.sqs.support.converter.SqsMessageConversionContext;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.model.Message;

@Deprecated
public class LegacyJackson2SqsMessagingMessageConverter
extends AbstractMessagingMessageConverter<Message> {
    public LegacyJackson2SqsMessagingMessageConverter() {
        super((MessageConverter)LegacyJackson2SqsMessagingMessageConverter.createDefaultCompositeMessageConverter());
    }

    private static CompositeMessageConverter createDefaultCompositeMessageConverter() {
        ArrayList<SimpleClassMatchingMessageConverter> messageConverters = new ArrayList<SimpleClassMatchingMessageConverter>();
        messageConverters.add(LegacyJackson2SqsMessagingMessageConverter.createClassMatchingMessageConverter());
        messageConverters.add((SimpleClassMatchingMessageConverter)LegacyJackson2SqsMessagingMessageConverter.createStringMessageConverter());
        messageConverters.add((SimpleClassMatchingMessageConverter)LegacyJackson2MessageConverterFactory.createDefaultMappingLegacyJackson2MessageConverter());
        return new CompositeMessageConverter(messageConverters);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"messageConverter cannot be null");
        MappingJackson2MessageConverter converter = this.getMappingJackson2MessageConverter().orElseThrow(() -> new IllegalStateException("%s can only be set in %s instances, or %s containing one.".formatted(ObjectMapper.class.getSimpleName(), MappingJackson2MessageConverter.class.getSimpleName(), CompositeMessageConverter.class.getSimpleName())));
        converter.setObjectMapper(objectMapper);
    }

    private Optional<MappingJackson2MessageConverter> getMappingJackson2MessageConverter() {
        Optional<MappingJackson2MessageConverter> optional;
        MessageConverter messageConverter = this.getPayloadMessageConverter();
        if (messageConverter instanceof CompositeMessageConverter) {
            CompositeMessageConverter compositeConverter = (CompositeMessageConverter)messageConverter;
            optional = compositeConverter.getConverters().stream().filter(converter -> converter instanceof MappingJackson2MessageConverter).map(MappingJackson2MessageConverter.class::cast).findFirst();
        } else {
            messageConverter = this.getPayloadMessageConverter();
            if (messageConverter instanceof MappingJackson2MessageConverter) {
                MappingJackson2MessageConverter converter2 = (MappingJackson2MessageConverter)messageConverter;
                optional = Optional.of(converter2);
            } else {
                optional = Optional.empty();
            }
        }
        return optional;
    }

    @Override
    protected HeaderMapper<Message> createDefaultHeaderMapper() {
        return new SqsHeaderMapper();
    }

    @Override
    protected Object getPayloadToDeserialize(Message message) {
        return message.body();
    }

    @Override
    public MessageConversionContext createMessageConversionContext() {
        return new SqsMessageConversionContext();
    }

    @Override
    protected Message doConvertMessage(Message messageWithHeaders, Object payload) {
        Assert.isInstanceOf(String.class, (Object)payload, (String)"payload must be instance of String");
        return (Message)messageWithHeaders.toBuilder().body((String)payload).build();
    }

    private static SimpleClassMatchingMessageConverter createClassMatchingMessageConverter() {
        SimpleClassMatchingMessageConverter matchingMessageConverter = new SimpleClassMatchingMessageConverter();
        matchingMessageConverter.setSerializedPayloadClass(String.class);
        return matchingMessageConverter;
    }

    private static StringMessageConverter createStringMessageConverter() {
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        return stringMessageConverter;
    }
}

