/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import io.awspring.cloud.sqs.support.converter.AbstractSnsJsonNode;
import org.springframework.messaging.converter.MessageConversionException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.json.JsonMapper;

public class SnsJsonNode
extends AbstractSnsJsonNode {
    private final String jsonString;
    private final JsonNode jsonNode;

    public SnsJsonNode(JsonMapper jsonMapper, String jsonString) {
        try {
            this.jsonString = jsonString;
            this.jsonNode = jsonMapper.readTree(jsonString);
        }
        catch (Exception e) {
            throw new MessageConversionException("Could not read JSON", (Throwable)e);
        }
        this.validate();
    }

    void validate() throws MessageConversionException {
        if (!this.jsonNode.has("Type")) {
            throw new MessageConversionException("Payload: '" + this.jsonString + "' does not contain a Type attribute", null);
        }
        if (!"Notification".equals(this.jsonNode.get("Type").asString())) {
            throw new MessageConversionException("Payload: '" + this.jsonString + "' is not a valid notification", null);
        }
        if (!this.jsonNode.has("Message")) {
            throw new MessageConversionException("Payload: '" + this.jsonString + "' does not contain a message", null);
        }
    }

    @Override
    public String getMessageAsString() {
        return this.jsonNode.get("Message").asString();
    }

    @Override
    public String getSubjectAsString() {
        if (!this.jsonNode.has("Subject")) {
            throw new MessageConversionException("Payload: '" + this.jsonString + "' does not contain a subject", null);
        }
        return this.jsonNode.get("Subject").asText();
    }
}

