/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.adapter;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class CompositeInvocableHandler {
    private final List<InvocableHandlerMethod> handlers;
    private final ConcurrentMap<Class<?>, InvocableHandlerMethod> cachedHandlers = new ConcurrentHashMap();
    private final @Nullable InvocableHandlerMethod defaultHandler;

    public CompositeInvocableHandler(InvocableHandlerMethod handler) {
        this(Collections.emptyList(), handler);
    }

    public CompositeInvocableHandler(List<InvocableHandlerMethod> handlers, @Nullable InvocableHandlerMethod defaultHandler) {
        this.handlers = handlers;
        this.defaultHandler = defaultHandler;
    }

    public @Nullable Object invoke(Message<?> message) throws Exception {
        if (this.handlers.isEmpty()) {
            if (this.defaultHandler == null) {
                throw new IllegalStateException("No handler found for message: " + message);
            }
            return this.defaultHandler.invoke(message, new Object[0]);
        }
        Class<?> payloadClass = message.getPayload().getClass();
        InvocableHandlerMethod handler = this.getHandlerForPayload(payloadClass);
        return handler.invoke(message, new Object[0]);
    }

    private InvocableHandlerMethod getHandlerForPayload(Class<?> payloadClass) {
        InvocableHandlerMethod handler = (InvocableHandlerMethod)this.cachedHandlers.get(payloadClass);
        if (handler == null) {
            handler = this.findHandlerForPayload(payloadClass);
            if (handler == null) {
                throw new IllegalStateException("No handler found for payload type: " + payloadClass);
            }
            this.cachedHandlers.putIfAbsent(payloadClass, handler);
        }
        return handler;
    }

    protected @Nullable InvocableHandlerMethod findHandlerForPayload(Class<?> payloadClass) {
        InvocableHandlerMethod result = null;
        for (InvocableHandlerMethod handler : this.handlers) {
            if (!this.matchHandlerMethod(payloadClass, handler)) continue;
            if (result != null && !result.equals((Object)this.defaultHandler)) {
                if (handler.equals((Object)this.defaultHandler)) continue;
                throw new IllegalArgumentException("Ambiguous handler method for payload type: " + payloadClass);
            }
            result = handler;
        }
        return result != null ? result : this.defaultHandler;
    }

    private boolean matchHandlerMethod(Class<?> payloadClass, InvocableHandlerMethod handler) {
        Method method = handler.getMethod();
        MethodParameter foundCandidate = this.findCandidate(payloadClass, method);
        return foundCandidate != null;
    }

    private @Nullable MethodParameter findCandidate(Class<?> payloadClass, Method method) {
        MethodParameter foundCandidate = null;
        for (int i = 0; i < method.getParameterCount(); ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i);
            if (!this.isPayloadAssignable(methodParameter, payloadClass)) continue;
            if (foundCandidate != null) {
                throw new IllegalArgumentException("Ambiguous payload parameter for " + method.toGenericString());
            }
            foundCandidate = methodParameter;
        }
        return foundCandidate;
    }

    private boolean isPayloadAssignable(MethodParameter methodParameter, Class<?> payloadClass) {
        return methodParameter.getParameterType().isAssignableFrom(payloadClass);
    }
}

