/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ListenerExecutionFailedException
extends RuntimeException {
    private static final Logger logger = LoggerFactory.getLogger(ListenerExecutionFailedException.class);
    private final Collection<Message<?>> failedMessages;

    public ListenerExecutionFailedException(String message, Throwable cause, Message<?> failedMessage) {
        super(message, cause);
        this.failedMessages = Collections.singletonList(failedMessage);
    }

    public <T> ListenerExecutionFailedException(String message, Throwable cause, Collection<Message<T>> failedMessages) {
        super(message, cause);
        this.failedMessages = failedMessages.stream().map(msg -> msg).collect(Collectors.toList());
    }

    public Message<?> getFailedMessage() {
        Assert.isTrue((this.failedMessages.size() == 1 ? 1 : 0) != 0, () -> "Not a unique failed message: " + this.failedMessages);
        return this.failedMessages.iterator().next();
    }

    public Collection<Message<?>> getFailedMessages() {
        return this.failedMessages;
    }

    public static <T> @Nullable Message<T> unwrapMessage(Throwable t) {
        Throwable exception = ListenerExecutionFailedException.findListenerException(t);
        return t == null ? null : (exception != null ? ((ListenerExecutionFailedException)exception).getFailedMessage() : (Message)ListenerExecutionFailedException.wrapAndRethrowError(t));
    }

    public static <T> @Nullable Collection<Message<T>> unwrapMessages(Throwable t) {
        Throwable exception = ListenerExecutionFailedException.findListenerException(t);
        return t == null ? null : (exception != null ? (Collection)((ListenerExecutionFailedException)exception).getFailedMessages().stream().map(msg -> msg).collect(Collectors.toList()) : (Collection)ListenerExecutionFailedException.wrapAndRethrowError(t));
    }

    private static @Nullable Throwable findListenerException(Throwable t) {
        return t == null ? null : (t instanceof ListenerExecutionFailedException ? t : ListenerExecutionFailedException.findListenerException(t.getCause()));
    }

    private static Object wrapAndRethrowError(Throwable t) {
        throw new IllegalArgumentException("No ListenerExecutionFailedException found to unwrap messages.", t);
    }

    public static boolean hasListenerException(Throwable t) {
        return ListenerExecutionFailedException.findListenerException(t) != null;
    }
}

