/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.config;

import io.awspring.cloud.sqs.config.AbstractEndpoint;
import io.awspring.cloud.sqs.config.Endpoint;
import io.awspring.cloud.sqs.listener.MessageListener;
import io.awspring.cloud.sqs.listener.MessageListenerContainer;
import io.awspring.cloud.sqs.listener.adapter.CompositeInvocableHandler;
import io.awspring.cloud.sqs.listener.adapter.MessagingMessageListenerAdapter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class MultiMethodSqsEndpoint
extends AbstractEndpoint {
    private final Endpoint endpoint;
    private final List<Method> methods;
    private final @Nullable Method defaultMethod;

    protected MultiMethodSqsEndpoint(MultiMethodSqsEndpointBuilder builder) {
        super(builder.queueNames, builder.factoryName, builder.id);
        this.methods = builder.methods;
        this.defaultMethod = builder.defaultMethod;
        this.endpoint = builder.endpoint;
        this.setBean(builder.bean);
    }

    public static MultiMethodSqsEndpointBuilder builder() {
        return new MultiMethodSqsEndpointBuilder();
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    @Override
    public <T> void setupContainer(MessageListenerContainer<T> container) {
        ArrayList<InvocableHandlerMethod> invocableHandlerMethods = new ArrayList<InvocableHandlerMethod>();
        InvocableHandlerMethod defaultHandler = null;
        for (Method method : this.methods) {
            MessageHandlerMethodFactory messageHandlerMethodFactory = this.getMessageHandlerMethodFactory();
            if (messageHandlerMethodFactory == null) continue;
            InvocableHandlerMethod invocableHandlerMethod = messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), method);
            invocableHandlerMethods.add(invocableHandlerMethod);
            if (!method.equals(this.defaultMethod)) continue;
            defaultHandler = invocableHandlerMethod;
        }
        CompositeInvocableHandler compositeInvocableHandler = new CompositeInvocableHandler(invocableHandlerMethods, defaultHandler);
        container.setMessageListener(this.createMessageListenerInstance(compositeInvocableHandler));
    }

    protected <T> MessageListener<T> createMessageListenerInstance(CompositeInvocableHandler compositeInvocableHandler) {
        return new MessagingMessageListenerAdapter(compositeInvocableHandler);
    }

    public static class MultiMethodSqsEndpointBuilder {
        private List<Method> methods;
        private @Nullable Method defaultMethod;
        private Object bean;
        private String id;
        private Collection<String> queueNames;
        private String factoryName;
        private Endpoint endpoint;

        public MultiMethodSqsEndpointBuilder methods(List<Method> methods) {
            this.methods = methods;
            return this;
        }

        public MultiMethodSqsEndpointBuilder defaultMethod(@Nullable Method defaultMethod) {
            this.defaultMethod = defaultMethod;
            return this;
        }

        public MultiMethodSqsEndpointBuilder bean(Object bean) {
            this.bean = bean;
            return this;
        }

        public MultiMethodSqsEndpointBuilder queueNames(Collection<String> queueNames) {
            this.queueNames = queueNames;
            return this;
        }

        public MultiMethodSqsEndpointBuilder factoryBeanName(String factoryName) {
            this.factoryName = factoryName;
            return this;
        }

        public MultiMethodSqsEndpointBuilder sqsEndpoint(Endpoint sqsEndpoint) {
            this.endpoint = sqsEndpoint;
            return this;
        }

        public MultiMethodSqsEndpointBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MultiMethodSqsEndpoint build() {
            return new MultiMethodSqsEndpoint(this);
        }
    }
}

