/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

public class LifecycleHandler {
    private static final LifecycleHandler INSTANCE = new LifecycleHandler();
    private final TaskExecutor taskExecutor;
    private boolean parallelLifecycle = true;

    public static LifecycleHandler get() {
        return INSTANCE;
    }

    private LifecycleHandler() {
        SimpleAsyncTaskExecutor sate = new SimpleAsyncTaskExecutor();
        sate.setThreadNamePrefix("lifecycle-thread-");
        this.taskExecutor = sate;
    }

    public void setParallelLifecycle(boolean parallelLifecycle) {
        this.parallelLifecycle = parallelLifecycle;
    }

    public void manageLifecycle(Consumer<SmartLifecycle> action, Object ... objects) {
        Arrays.stream(objects).forEach(object -> {
            if (object instanceof SmartLifecycle) {
                action.accept((SmartLifecycle)object);
            } else if (object instanceof Collection) {
                if (this.parallelLifecycle) {
                    CompletableFuture.allOf((CompletableFuture[])((Collection)object).stream().map(obj -> CompletableFuture.runAsync(() -> this.manageLifecycle(action, obj), (Executor)this.taskExecutor)).toArray(CompletableFuture[]::new)).join();
                } else {
                    ((Collection)object).forEach(obj -> this.manageLifecycle(action, obj));
                }
            }
        });
    }

    public void start(Object ... objects) {
        this.manageLifecycle(Lifecycle::start, objects);
    }

    public void stop(Object ... objects) {
        this.manageLifecycle(Lifecycle::stop, objects);
    }

    public boolean isRunning(Object object) {
        if (object instanceof SmartLifecycle) {
            return ((SmartLifecycle)object).isRunning();
        }
        return true;
    }

    public void dispose(Object destroyable) {
        if (destroyable instanceof DisposableBean) {
            try {
                ((DisposableBean)destroyable).destroy();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error destroying disposable " + destroyable);
            }
        }
    }
}

