/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.resolver;

import io.awspring.cloud.sqs.annotation.SnsNotificationMessage;
import io.awspring.cloud.sqs.support.converter.SnsMessageConverter;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import tools.jackson.databind.json.JsonMapper;

public class NotificationMessageArgumentResolver
implements HandlerMethodArgumentResolver {
    private final SmartMessageConverter converter;

    public NotificationMessageArgumentResolver(MessageConverter converter, JsonMapper jsonMapper) {
        this.converter = new SnsMessageConverter(converter, jsonMapper);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(SnsNotificationMessage.class);
    }

    public Object resolveArgument(MethodParameter par, Message<?> msg) {
        return this.converter.fromMessage(msg, par.getParameterType(), (Object)par);
    }
}

