/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.observation;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.support.observation.AbstractTemplateObservation;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.util.StringUtils;

public class SqsTemplateObservation {

    public static class SqsSpecifics
    implements AbstractTemplateObservation.Specifics<Context> {
        private static final DefaultConvention CONVENTION_INSTANCE = new DefaultConvention();
        private static final Documentation DOCUMENTATION_INSTANCE = new Documentation();

        @Override
        public Context createContext(Message<?> message, String destinationName) {
            return new Context(message, destinationName);
        }

        @Override
        public ObservationConvention<Context> getDefaultConvention() {
            return CONVENTION_INSTANCE;
        }

        @Override
        public ObservationDocumentation getDocumentation() {
            return DOCUMENTATION_INSTANCE;
        }
    }

    public static class DefaultConvention
    extends AbstractTemplateObservation.Convention<Context>
    implements Convention {
        @Override
        protected String getSourceKind() {
            return "queue";
        }

        @Override
        protected String getMessagingSystem() {
            return "sqs";
        }

        @Override
        protected KeyValues getSpecificHighCardinalityKeyValues(Context context) {
            String messageDeduplicationId = context.getMessageDeduplicationId();
            String messageGroupId = context.getMessageGroupId();
            return StringUtils.hasText((String)messageGroupId) && StringUtils.hasText((String)messageDeduplicationId) ? KeyValues.of((KeyValue[])new KeyValue[]{Documentation.HighCardinalityTags.MESSAGE_GROUP_ID.withValue(messageGroupId), Documentation.HighCardinalityTags.MESSAGE_DEDUPLICATION_ID.withValue(messageDeduplicationId)}) : KeyValues.empty();
        }
    }

    public static class Context
    extends AbstractTemplateObservation.Context {
        private final String messageGroupId;
        private final String messageDeduplicationId;

        public Context(Message<?> message, String destinationName) {
            super(message, destinationName);
            this.messageGroupId = message.getHeaders().containsKey((Object)"Sqs_Msa_MessageGroupId") ? MessageHeaderUtils.getHeaderAsString(message, "Sqs_Msa_MessageGroupId") : "";
            this.messageDeduplicationId = message.getHeaders().containsKey((Object)"Sqs_Msa_MessageDeduplicationId") ? MessageHeaderUtils.getHeaderAsString(message, "Sqs_Msa_MessageDeduplicationId") : "";
            this.setRemoteServiceName("AWS SQS");
        }

        public String getMessageGroupId() {
            return this.messageGroupId;
        }

        public String getMessageDeduplicationId() {
            return this.messageDeduplicationId;
        }
    }

    public static interface Convention
    extends ObservationConvention<Context> {
        default public boolean supportsContext(@NonNull Observation.Context context) {
            return context instanceof Context;
        }

        default public String getName() {
            return "spring.cloud.aws.sqs.template";
        }
    }

    public static class Documentation
    extends AbstractTemplateObservation.Documentation {
        @Override
        protected Class<? extends ObservationConvention<? extends Observation.Context>> getSpecificDefaultConvention() {
            return DefaultConvention.class;
        }

        @Override
        protected KeyName[] getSpecificHighCardinalityKeyNames() {
            return HighCardinalityTags.values();
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum HighCardinalityTags implements KeyName
        {
            MESSAGE_GROUP_ID{

                @NonNull
                public String asString() {
                    return "messaging.message.message-group.id";
                }
            }
            ,
            MESSAGE_DEDUPLICATION_ID{

                @NonNull
                public String asString() {
                    return "messaging.message.message-deduplication.id";
                }
            };

        }
    }
}

