/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.adapter;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.ListenerExecutionFailedException;
import io.awspring.cloud.sqs.listener.adapter.CompositeInvocableHandler;
import java.util.Collection;
import java.util.Collections;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public abstract class AbstractMethodInvokingListenerAdapter<T> {
    private final CompositeInvocableHandler compositeInvocableHandler;

    protected AbstractMethodInvokingListenerAdapter(InvocableHandlerMethod handlerMethod) {
        Assert.notNull((Object)handlerMethod, (String)"handlerMethod cannot be null");
        this.compositeInvocableHandler = new CompositeInvocableHandler(handlerMethod);
    }

    protected AbstractMethodInvokingListenerAdapter(CompositeInvocableHandler compositeInvocableHandler) {
        Assert.notNull((Object)compositeInvocableHandler, (String)"compositeInvocableHandler cannot be null");
        this.compositeInvocableHandler = compositeInvocableHandler;
    }

    protected final Object invokeHandler(Message<T> message) {
        try {
            return this.compositeInvocableHandler.invoke(message);
        }
        catch (Throwable t) {
            throw this.createListenerException(message, t);
        }
    }

    protected final Object invokeHandler(Collection<Message<T>> messages) {
        try {
            return this.compositeInvocableHandler.invoke(MessageBuilder.withPayload(messages).build());
        }
        catch (Throwable t) {
            throw this.createListenerException(messages, t);
        }
    }

    protected ListenerExecutionFailedException createListenerException(Collection<Message<T>> messages, Throwable t) {
        return new ListenerExecutionFailedException("Listener failed to process messages " + MessageHeaderUtils.getId(messages), t, messages);
    }

    protected ListenerExecutionFailedException createListenerException(Message<T> message, Throwable t) {
        return this.createListenerException(Collections.singletonList(message), t);
    }
}

