/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.pipeline;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.MessageProcessingContext;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import io.awspring.cloud.sqs.listener.pipeline.MessageProcessingPipeline;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractBeforeProcessingInterceptorExecutionStage<T>
implements MessageProcessingPipeline<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBeforeProcessingInterceptorExecutionStage.class);

    @Override
    public CompletableFuture<Message<T>> process(Message<T> message, MessageProcessingContext<T> context) {
        logger.trace("Processing message {}", (Object)MessageHeaderUtils.getId(message));
        return this.getInterceptors(context).stream().reduce(CompletableFuture.completedFuture(message), (messageFuture, interceptor) -> ((CompletableFuture)messageFuture.thenCompose(interceptor::intercept)).thenApply(this.validateMessageNotNull()), (a, b) -> a);
    }

    @Override
    public CompletableFuture<Collection<Message<T>>> process(Collection<Message<T>> messages, MessageProcessingContext<T> context) {
        logger.trace("Processing messages {}", (Object)MessageHeaderUtils.getId(messages));
        return this.getInterceptors(context).stream().reduce(CompletableFuture.completedFuture(messages), (messageFuture, interceptor) -> ((CompletableFuture)messageFuture.thenCompose(interceptor::intercept)).thenApply(this.validateMessagesNotEmpty()), (a, b) -> a);
    }

    protected abstract Collection<AsyncMessageInterceptor<T>> getInterceptors(MessageProcessingContext<T> var1);

    private Function<Message<T>, Message<T>> validateMessageNotNull() {
        return msg -> {
            Assert.notNull((Object)msg, (String)"Interceptor must not return null messages");
            return msg;
        };
    }

    private Function<Collection<Message<T>>, Collection<Message<T>>> validateMessagesNotEmpty() {
        return msgs -> {
            Assert.notEmpty((Collection)msgs, (String)"Interceptor must not return null or empty collection");
            return msgs;
        };
    }
}

