/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.backpressure;

import io.awspring.cloud.sqs.listener.IdentifiableContainerComponent;
import io.awspring.cloud.sqs.listener.backpressure.BackPressureHandler;
import io.awspring.cloud.sqs.listener.backpressure.BatchAwareBackPressureHandler;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CompositeBackPressureHandler
implements BatchAwareBackPressureHandler,
IdentifiableContainerComponent {
    private static final Logger logger = LoggerFactory.getLogger(CompositeBackPressureHandler.class);
    private String id;
    private final int batchSize;
    private final Duration noPermitsReturnedWaitTimeout;
    private final List<BackPressureHandler> backPressureHandlers;
    private final ReentrantLock noPermitsReturnedWaitLock = new ReentrantLock();
    private final Condition permitsReleasedCondition = this.noPermitsReturnedWaitLock.newCondition();

    private CompositeBackPressureHandler(Builder builder) {
        this.batchSize = builder.batchSize;
        this.noPermitsReturnedWaitTimeout = builder.noPermitsReturnedWaitTimeout;
        this.backPressureHandlers = List.copyOf(builder.backPressureHandlers);
    }

    @Override
    public void setId(String id) {
        this.id = id;
        this.backPressureHandlers.stream().filter(IdentifiableContainerComponent.class::isInstance).map(IdentifiableContainerComponent.class::cast).forEach(bph -> bph.setId(bph.getClass().getSimpleName() + "-" + id));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int requestBatch() throws InterruptedException {
        return this.request(this.batchSize);
    }

    @Override
    public int request(int amount) throws InterruptedException {
        int i;
        logger.debug("[{}] Requesting {} permits", (Object)this.id, (Object)amount);
        int obtained = amount;
        int[] obtainedPerBph = new int[this.backPressureHandlers.size()];
        for (i = 0; i < this.backPressureHandlers.size() && obtained > 0; ++i) {
            obtainedPerBph[i] = this.backPressureHandlers.get(i).request(obtained);
            obtained = Math.min(obtained, obtainedPerBph[i]);
        }
        for (i = 0; i < this.backPressureHandlers.size(); ++i) {
            int obtainedForBph = obtainedPerBph[i];
            if (obtainedForBph <= obtained) continue;
            this.backPressureHandlers.get(i).release(obtainedForBph - obtained, BackPressureHandler.ReleaseReason.LIMITED);
        }
        if (obtained == 0) {
            this.waitForPermitsToBeReleased();
        }
        logger.debug("[{}] Obtained {} permits ({} requested)", new Object[]{this.id, obtained, amount});
        return obtained;
    }

    @Override
    public void release(int amount, BackPressureHandler.ReleaseReason reason) {
        logger.debug("[{}] Releasing {} permits ({})", new Object[]{this.id, amount, reason});
        for (BackPressureHandler handler : this.backPressureHandlers) {
            handler.release(amount, reason);
        }
        if (amount > 0) {
            this.signalPermitsWereReleased();
        }
    }

    private void waitForPermitsToBeReleased() throws InterruptedException {
        this.noPermitsReturnedWaitLock.lock();
        try {
            logger.trace("[{}] No permits were obtained, waiting for a release up to {}", (Object)this.id, (Object)this.noPermitsReturnedWaitTimeout);
            this.permitsReleasedCondition.await(this.noPermitsReturnedWaitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        finally {
            this.noPermitsReturnedWaitLock.unlock();
        }
    }

    private void signalPermitsWereReleased() {
        this.noPermitsReturnedWaitLock.lock();
        try {
            this.permitsReleasedCondition.signal();
        }
        finally {
            this.noPermitsReturnedWaitLock.unlock();
        }
    }

    @Override
    public boolean drain(Duration timeout) {
        logger.debug("[{}] Draining back-pressure handlers initiated", (Object)this.id);
        boolean result = true;
        Instant start = Instant.now();
        for (BackPressureHandler handler : this.backPressureHandlers) {
            Duration remainingTimeout = CompositeBackPressureHandler.maxDuration(timeout.minus(Duration.between(start, Instant.now())), Duration.ZERO);
            result &= handler.drain(remainingTimeout);
        }
        logger.debug("[{}] Draining back-pressure handlers completed", (Object)this.id);
        return result;
    }

    private static Duration maxDuration(Duration first, Duration second) {
        return first.compareTo(second) > 0 ? first : second;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int batchSize;
        private Duration noPermitsReturnedWaitTimeout;
        private List<BackPressureHandler> backPressureHandlers;

        public Builder backPressureHandlers(List<BackPressureHandler> backPressureHandlers) {
            this.backPressureHandlers = backPressureHandlers;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder noPermitsReturnedWaitTimeout(Duration noPermitsReturnedWaitTimeout) {
            this.noPermitsReturnedWaitTimeout = noPermitsReturnedWaitTimeout;
            return this;
        }

        public CompositeBackPressureHandler build() {
            Assert.notNull((Object)this.batchSize, (String)"Missing configuration for batch size");
            Assert.notNull((Object)this.noPermitsReturnedWaitTimeout, (String)"Missing configuration for noPermitsReturnedWaitTimeout");
            Assert.noNullElements(this.backPressureHandlers, (String)"backPressureHandlers must not be null");
            return new CompositeBackPressureHandler(this);
        }
    }
}

