/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs;

import io.awspring.cloud.sqs.support.converter.MessagingMessageHeaders;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class MessageHeaderUtils {
    private MessageHeaderUtils() {
    }

    public static String getId(Message<?> message) {
        return MessageHeaderUtils.getHeader(message, "id", UUID.class).toString();
    }

    public static <T> String getId(Collection<Message<T>> messages) {
        return messages.stream().map(MessageHeaderUtils::getId).collect(Collectors.joining("; "));
    }

    public static <T> T getHeader(Message<?> message, String headerName, Class<T> classToCast) {
        return (T)Objects.requireNonNull(message.getHeaders().get((Object)headerName, classToCast), () -> String.format("Header %s not found in message %s", headerName, message));
    }

    public static <T, U> Collection<T> getHeader(Collection<Message<U>> messages, String headerName, Class<T> classToCast) {
        return messages.stream().map(msg -> MessageHeaderUtils.getHeader(msg, headerName, classToCast)).collect(Collectors.toList());
    }

    public static String getHeaderAsString(Message<?> message, String headerName) {
        return MessageHeaderUtils.getHeader(message, headerName, String.class);
    }

    public static <T> Message<T> addHeaderIfAbsent(Message<T> message, String headerName, Object headerValue) {
        return MessageHeaderUtils.addHeadersIfAbsent(message, Map.of(headerName, headerValue));
    }

    public static <T> Message<T> addHeadersIfAbsent(Message<T> message, Map<String, Object> newHeaders) {
        return new GenericMessage(message.getPayload(), MessageHeaderUtils.addHeadersIfAbsent(message.getHeaders(), newHeaders));
    }

    public static MessageHeaders addHeaderIfAbsent(MessageHeaders headers, String headerName, Object headerValue) {
        return MessageHeaderUtils.addHeadersIfAbsent(headers, Map.of(headerName, headerValue));
    }

    public static MessageHeaders addHeadersIfAbsent(MessageHeaders headers, Map<String, Object> newHeaders) {
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        accessor.copyHeaders((Map)headers);
        accessor.copyHeadersIfAbsent(newHeaders);
        return new MessagingMessageHeaders((Map<String, Object>)accessor.toMessageHeaders(), headers.getId(), headers.getTimestamp());
    }

    public static <T> Message<T> removeHeaderIfPresent(Message<T> message, String key) {
        if (!message.getHeaders().containsKey((Object)key)) {
            return message;
        }
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        MessageHeaders headers = message.getHeaders();
        accessor.copyHeaders((Map)headers);
        accessor.removeHeader(key);
        MessagingMessageHeaders newHeaders = new MessagingMessageHeaders((Map<String, Object>)accessor.toMessageHeaders(), headers.getId(), headers.getTimestamp());
        return new GenericMessage(message.getPayload(), (MessageHeaders)newHeaders);
    }
}

