/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.errorhandler;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.BatchVisibility;
import io.awspring.cloud.sqs.listener.QueueMessageVisibility;
import io.awspring.cloud.sqs.listener.Visibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.messaging.Message;

public class ErrorHandlerVisibilityHelper {
    public static <T> Map<Long, List<Message<T>>> groupMessagesByReceiveMessageCount(Collection<Message<T>> messages) {
        return messages.stream().collect(Collectors.groupingBy(ErrorHandlerVisibilityHelper::getReceiveMessageCount));
    }

    public static <T> Collection<Message<?>> castMessages(Collection<Message<T>> messages) {
        return new ArrayList(messages);
    }

    public static <T> Visibility getVisibility(Message<T> message) {
        return MessageHeaderUtils.getHeader(message, "Sqs_VisibilityTimeout", Visibility.class);
    }

    public static <T> BatchVisibility getVisibility(Collection<Message<T>> messages) {
        Collection<Message<?>> castMessages = ErrorHandlerVisibilityHelper.castMessages(messages);
        QueueMessageVisibility firstVisibilityMessage = (QueueMessageVisibility)ErrorHandlerVisibilityHelper.getVisibility(messages.iterator().next());
        return firstVisibilityMessage.toBatchVisibility(castMessages);
    }

    public static <T> long getReceiveMessageCount(Message<T> message) {
        return Long.parseLong(MessageHeaderUtils.getHeaderAsString(message, "Sqs_Msa_ApproximateReceiveCount"));
    }
}

