/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.messaging.converter.MessageConversionException;

public class SnsJsonNode {
    private final String jsonString;
    private final JsonNode jsonNode;

    public SnsJsonNode(ObjectMapper jsonMapper, String jsonString) {
        try {
            this.jsonString = jsonString;
            this.jsonNode = jsonMapper.readTree(jsonString);
        }
        catch (Exception e) {
            throw new MessageConversionException("Could not read JSON", (Throwable)e);
        }
        this.validate();
    }

    void validate() throws MessageConversionException {
        if (!this.jsonNode.has("Type")) {
            throw new MessageConversionException("Payload: '" + this.jsonString + "' does not contain a Type attribute", null);
        }
        if (!"Notification".equals(this.jsonNode.get("Type").asText())) {
            throw new MessageConversionException("Payload: '" + this.jsonString + "' is not a valid notification", null);
        }
        if (!this.jsonNode.has("Message")) {
            throw new MessageConversionException("Payload: '" + this.jsonString + "' does not contain a message", null);
        }
    }

    public String getMessageAsString() {
        return this.jsonNode.get("Message").asText();
    }

    public String getSubjectAsString() {
        if (!this.jsonNode.has("Subject")) {
            throw new MessageConversionException("Payload: '" + this.jsonString + "' does not contain a subject", null);
        }
        return this.jsonNode.get("Subject").asText();
    }
}

