/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.source;

import io.awspring.cloud.sqs.ConfigUtils;
import io.awspring.cloud.sqs.listener.ContainerOptions;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementCallback;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementMode;
import io.awspring.cloud.sqs.listener.source.MessageSource;
import io.awspring.cloud.sqs.support.converter.AcknowledgementAwareMessageConversionContext;
import io.awspring.cloud.sqs.support.converter.ContextAwareMessagingMessageConverter;
import io.awspring.cloud.sqs.support.converter.MessageConversionContext;
import io.awspring.cloud.sqs.support.converter.MessagingMessageConverter;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public abstract class AbstractMessageConvertingMessageSource<T, S>
implements MessageSource<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageConvertingMessageSource.class);
    private MessagingMessageConverter<S> messagingMessageConverter;
    @Nullable
    private MessageConversionContext messageConversionContext;
    private AcknowledgementMode acknowledgementMode;

    @Override
    public void configure(ContainerOptions<?, ?> containerOptions) {
        this.messagingMessageConverter = containerOptions.getMessageConverter();
        this.messageConversionContext = this.maybeCreateConversionContext();
        this.acknowledgementMode = containerOptions.getAcknowledgementMode();
        this.configureMessageSource(containerOptions);
    }

    protected void configureMessageSource(ContainerOptions<?, ?> containerOptions) {
    }

    protected void setupAcknowledgementForConversion(AcknowledgementCallback<T> callback) {
        if (this.acknowledgementMode.equals((Object)AcknowledgementMode.MANUAL)) {
            ConfigUtils.INSTANCE.acceptIfInstance(this.messageConversionContext, AcknowledgementAwareMessageConversionContext.class, aamcc -> aamcc.setAcknowledgementCallback(callback));
        }
    }

    @Nullable
    private MessageConversionContext maybeCreateConversionContext() {
        return this.messagingMessageConverter instanceof ContextAwareMessagingMessageConverter ? ((ContextAwareMessagingMessageConverter)this.messagingMessageConverter).createMessageConversionContext() : null;
    }

    protected Collection<Message<T>> convertMessages(Collection<S> messages) {
        return messages.stream().map(this::convertMessage).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    protected Message<T> convertMessage(S msg) {
        try {
            logger.trace("Converting message {}", msg);
            return this.messagingMessageConverter instanceof ContextAwareMessagingMessageConverter ? this.getContextAwareConverter().toMessagingMessage(msg, this.messageConversionContext) : this.messagingMessageConverter.toMessagingMessage(msg);
        }
        catch (Exception e) {
            logger.error("Error converting message {}, ignoring.", msg, (Object)e);
            return null;
        }
    }

    private ContextAwareMessagingMessageConverter<S> getContextAwareConverter() {
        return (ContextAwareMessagingMessageConverter)this.messagingMessageConverter;
    }

    @Nullable
    protected MessageConversionContext getMessageConversionContext() {
        return this.messageConversionContext;
    }
}

