/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.annotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.sqs.ConfigUtils;
import io.awspring.cloud.sqs.config.Endpoint;
import io.awspring.cloud.sqs.config.EndpointRegistrar;
import io.awspring.cloud.sqs.config.HandlerMethodEndpoint;
import io.awspring.cloud.sqs.config.SqsListenerConfigurer;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementMode;
import io.awspring.cloud.sqs.support.resolver.AcknowledgmentHandlerMethodArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.BatchAcknowledgmentArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.BatchPayloadMethodArgumentResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SimpleMessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractListenerAnnotationBeanPostProcessor<A extends Annotation>
implements BeanPostProcessor,
BeanFactoryAware,
SmartInitializingSingleton {
    private final AtomicInteger counter = new AtomicInteger();
    private final Collection<Class<?>> nonAnnotatedClasses = Collections.synchronizedSet(new HashSet());
    private final EndpointRegistrar endpointRegistrar = this.createEndpointRegistrar();
    private final DelegatingMessageHandlerMethodFactory delegatingHandlerMethodFactory = new DelegatingMessageHandlerMethodFactory();
    private BeanFactory beanFactory;
    @Nullable
    private BeanExpressionResolver expressionResolver;
    @Nullable
    private BeanExpressionContext expressionContext;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (this.nonAnnotatedClasses.contains(targetClass)) {
            return bean;
        }
        this.detectAnnotationsAndRegisterEndpoints(bean, targetClass);
        return bean;
    }

    @Nullable
    protected ConfigurableBeanFactory getConfigurableBeanFactory() {
        return this.beanFactory instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)this.beanFactory : null;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected void detectAnnotationsAndRegisterEndpoints(Object bean, Class<?> targetClass) {
        Map annotatedMethods = MethodIntrospector.selectMethods(targetClass, method -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, this.getAnnotationClass()));
        if (annotatedMethods.isEmpty()) {
            this.nonAnnotatedClasses.add(targetClass);
        }
        annotatedMethods.entrySet().stream().map(entry -> this.createAndConfigureEndpoint(bean, (Method)entry.getKey(), (Annotation)entry.getValue())).forEach(this.endpointRegistrar::registerEndpoint);
    }

    protected abstract Class<A> getAnnotationClass();

    private Endpoint createAndConfigureEndpoint(Object bean, Method method, A annotation) {
        Endpoint endpoint = this.createEndpoint(annotation);
        ConfigUtils.INSTANCE.acceptIfInstance(endpoint, HandlerMethodEndpoint.class, hme -> {
            hme.setBean(bean);
            hme.setMethod(method);
            hme.setHandlerMethodFactory(this.delegatingHandlerMethodFactory);
        });
        return endpoint;
    }

    protected abstract Endpoint createEndpoint(A var1);

    protected Collection<String> resolveEndpointNames(String[] endpointNames) {
        return Arrays.stream(endpointNames).map(this::resolveExpression).flatMap(resolvedName -> this.resolveAsStrings(resolvedName).stream()).collect(Collectors.toList());
    }

    @Nullable
    private Object resolveExpression(String value) {
        return this.getExpressionResolver() != null ? this.getExpressionResolver().evaluate(this.resolve(value), this.getExpressionContext()) : value;
    }

    @Nullable
    protected BeanExpressionResolver getExpressionResolver() {
        BeanFactory beanFactory;
        if (this.expressionResolver == null && (beanFactory = this.beanFactory) instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory clbf = (ConfigurableListableBeanFactory)beanFactory;
            this.expressionResolver = clbf.getBeanExpressionResolver();
        }
        return this.expressionResolver;
    }

    @Nullable
    private BeanExpressionContext getExpressionContext() {
        BeanFactory beanFactory;
        if (this.expressionContext == null && (beanFactory = this.beanFactory) instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory clbf = (ConfigurableBeanFactory)beanFactory;
            this.expressionContext = new BeanExpressionContext(clbf, null);
        }
        return this.expressionContext;
    }

    @Nullable
    private String resolve(String value) {
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
            return cbf.resolveEmbeddedValue(value);
        }
        return value;
    }

    protected String resolveAsString(String value, String propertyName) {
        try {
            Collection<String> resolvedStrings = this.resolveAsStrings(this.resolve(value));
            return resolvedStrings.isEmpty() ? value : resolvedStrings.iterator().next();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not resolve property " + propertyName, e);
        }
    }

    private Collection<String> resolveAsStrings(@Nullable Object resolvedValue) {
        if (resolvedValue instanceof String[]) {
            String[] strArr = (String[])resolvedValue;
            return this.resolveFromStream(Arrays.stream(strArr));
        }
        if (resolvedValue instanceof Iterable) {
            Iterable itr = (Iterable)resolvedValue;
            return this.resolveFromStream(StreamSupport.stream(itr.spliterator(), false));
        }
        if (resolvedValue instanceof String) {
            String str = (String)resolvedValue;
            return Collections.singletonList(str);
        }
        throw new IllegalArgumentException("Cannot resolve " + resolvedValue + " as String");
    }

    private List<String> resolveFromStream(Stream<?> stream) {
        return stream.flatMap(str -> this.resolveAsStrings(str).stream()).collect(Collectors.toList());
    }

    @Nullable
    protected Integer resolveAsInteger(String value, String propertyName) {
        try {
            Integer n;
            Object resolvedValue = this.resolveExpression(value);
            if (resolvedValue instanceof Number) {
                Number numberValue = (Number)resolvedValue;
                n = numberValue.intValue();
            } else {
                String stringValue;
                n = resolvedValue instanceof String && StringUtils.hasText((String)(stringValue = (String)resolvedValue)) ? Integer.valueOf(Integer.parseInt(stringValue)) : null;
            }
            return n;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot resolve " + propertyName + " as Integer");
        }
    }

    @Nullable
    protected AcknowledgementMode resolveAcknowledgement(String value) {
        try {
            String resolvedValue = this.resolveAsString(value, "acknowledgementMode");
            return StringUtils.hasText((String)resolvedValue) ? AcknowledgementMode.valueOf(resolvedValue) : null;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot resolve " + value + " as AcknowledgementMode", e);
        }
    }

    protected String getEndpointId(String id) {
        if (StringUtils.hasText((String)id)) {
            return this.resolveAsString(id, "id");
        }
        return this.getGeneratedIdPrefix() + this.counter.getAndIncrement();
    }

    protected abstract String getGeneratedIdPrefix();

    public void afterSingletonsInstantiated() {
        this.endpointRegistrar.setMessageListenerContainerRegistryBeanName(this.getMessageListenerContainerRegistryBeanName());
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            lbf.getBeansOfType(SqsListenerConfigurer.class).values().forEach(customizer -> customizer.configure(this.endpointRegistrar));
        }
        this.endpointRegistrar.setBeanFactory(this.getBeanFactory());
        this.initializeHandlerMethodFactory();
        this.endpointRegistrar.afterSingletonsInstantiated();
    }

    protected abstract String getMessageListenerContainerRegistryBeanName();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected void initializeHandlerMethodFactory() {
        MessageHandlerMethodFactory handlerMethodFactory = this.endpointRegistrar.getMessageHandlerMethodFactory();
        ConfigUtils.INSTANCE.acceptIfInstance(handlerMethodFactory, DefaultMessageHandlerMethodFactory.class, this::configureDefaultHandlerMethodFactory);
        this.delegatingHandlerMethodFactory.setDelegate(handlerMethodFactory);
    }

    protected void configureDefaultHandlerMethodFactory(DefaultMessageHandlerMethodFactory handlerMethodFactory) {
        CompositeMessageConverter compositeMessageConverter = this.createCompositeMessageConverter();
        ArrayList<HandlerMethodArgumentResolver> methodArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(this.createAdditionalArgumentResolvers());
        methodArgumentResolvers.addAll(this.createArgumentResolvers((MessageConverter)compositeMessageConverter));
        this.endpointRegistrar.getMethodArgumentResolversConsumer().accept(methodArgumentResolvers);
        handlerMethodFactory.setArgumentResolvers(methodArgumentResolvers);
        handlerMethodFactory.afterPropertiesSet();
    }

    protected Collection<HandlerMethodArgumentResolver> createAdditionalArgumentResolvers() {
        return Collections.emptyList();
    }

    protected CompositeMessageConverter createCompositeMessageConverter() {
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(new StringMessageConverter());
        messageConverters.add(new SimpleMessageConverter());
        messageConverters.add(this.createDefaultMappingJackson2MessageConverter(this.endpointRegistrar.getObjectMapper()));
        this.endpointRegistrar.getMessageConverterConsumer().accept(messageConverters);
        return new CompositeMessageConverter(messageConverters);
    }

    protected List<HandlerMethodArgumentResolver> createArgumentResolvers(MessageConverter messageConverter) {
        return Arrays.asList(new AcknowledgmentHandlerMethodArgumentResolver(), new BatchAcknowledgmentArgumentResolver(), new HeaderMethodArgumentResolver((ConversionService)new DefaultConversionService(), this.getConfigurableBeanFactory()), new HeadersMethodArgumentResolver(), new BatchPayloadMethodArgumentResolver(messageConverter, this.endpointRegistrar.getValidator()), new MessageMethodArgumentResolver(messageConverter), new PayloadMethodArgumentResolver(messageConverter, this.endpointRegistrar.getValidator()));
    }

    protected MappingJackson2MessageConverter createDefaultMappingJackson2MessageConverter(ObjectMapper objectMapper) {
        MappingJackson2MessageConverter jacksonMessageConverter = new MappingJackson2MessageConverter();
        jacksonMessageConverter.setSerializedPayloadClass(String.class);
        jacksonMessageConverter.setStrictContentTypeMatch(false);
        if (objectMapper != null) {
            jacksonMessageConverter.setObjectMapper(objectMapper);
        }
        return jacksonMessageConverter;
    }

    protected EndpointRegistrar createEndpointRegistrar() {
        return new EndpointRegistrar();
    }

    private static class DelegatingMessageHandlerMethodFactory
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory delegate;

        private DelegatingMessageHandlerMethodFactory() {
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            Assert.notNull((Object)this.delegate, (String)"No delegate MessageHandlerMethodFactory set.");
            return this.delegate.createInvocableHandlerMethod(bean, method);
        }

        public void setDelegate(MessageHandlerMethodFactory delegate) {
            this.delegate = delegate;
        }
    }
}

