/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import io.awspring.cloud.sqs.ConfigUtils;
import io.awspring.cloud.sqs.listener.QueueAttributes;
import io.awspring.cloud.sqs.listener.QueueMessageVisibility;
import io.awspring.cloud.sqs.support.converter.AcknowledgementAwareMessageConversionContext;
import io.awspring.cloud.sqs.support.converter.ContextAwareHeaderMapper;
import io.awspring.cloud.sqs.support.converter.MessageConversionContext;
import io.awspring.cloud.sqs.support.converter.MessagingMessageHeaders;
import io.awspring.cloud.sqs.support.converter.SqsMessageConversionContext;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.NumberUtils;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;

public class SqsHeaderMapper
implements ContextAwareHeaderMapper<Message> {
    private static final Logger logger = LoggerFactory.getLogger(SqsHeaderMapper.class);
    private BiFunction<Message, MessageHeaderAccessor, MessageHeaders> additionalHeadersFunction = (message, accessor) -> accessor.toMessageHeaders();

    public void setAdditionalHeadersFunction(BiFunction<Message, MessageHeaderAccessor, MessageHeaders> headerFunction) {
        Assert.notNull(headerFunction, (String)"headerFunction cannot be null");
        this.additionalHeadersFunction = headerFunction;
    }

    @Override
    public Message fromHeaders(MessageHeaders headers) {
        Message.Builder builder = Message.builder();
        HashMap<MessageSystemAttributeName, String> attributes = new HashMap<MessageSystemAttributeName, String>();
        if (headers.containsKey((Object)"Sqs_Msa_MessageGroupId")) {
            attributes.put(MessageSystemAttributeName.MESSAGE_GROUP_ID, headers.get((Object)"Sqs_Msa_MessageGroupId").toString());
        }
        if (headers.containsKey((Object)"Sqs_Msa_MessageDeduplicationId")) {
            attributes.put(MessageSystemAttributeName.MESSAGE_DEDUPLICATION_ID, headers.get((Object)"Sqs_Msa_MessageDeduplicationId").toString());
        }
        Map<String, MessageAttributeValue> messageAttributes = headers.entrySet().stream().filter(entry -> !this.isSkipHeader((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getMessageAttributeValue((String)entry.getKey(), entry.getValue())));
        if (headers.containsKey((Object)"Sqs_Delay")) {
            messageAttributes.put("Sqs_Delay", this.getNumberMessageAttribute(Objects.requireNonNull((Integer)headers.get((Object)"Sqs_Delay", Integer.class), "Delay header value must not be null")));
        }
        String messageId = Objects.requireNonNull(headers.getId(), "No ID found for message").toString();
        return (Message)builder.attributes(attributes).messageId(messageId).messageAttributes(messageAttributes).build();
    }

    private MessageAttributeValue getMessageAttributeValue(String messageHeaderName, @Nullable Object messageHeaderValue) {
        if ("contentType".equals(messageHeaderName) && messageHeaderValue != null) {
            return this.getContentTypeMessageAttribute(messageHeaderValue);
        }
        if (messageHeaderValue instanceof String) {
            return this.getStringMessageAttribute((String)messageHeaderValue);
        }
        if (messageHeaderValue instanceof Number) {
            return this.getNumberMessageAttribute(messageHeaderValue);
        }
        if (messageHeaderValue instanceof ByteBuffer) {
            return this.getBinaryMessageAttribute((ByteBuffer)messageHeaderValue);
        }
        return this.getStringMessageAttribute(messageHeaderValue != null ? messageHeaderValue.toString() : "");
    }

    private boolean isSkipHeader(String headerName) {
        return "Sqs_Msa_MessageGroupId".equals(headerName) || "Sqs_Msa_MessageDeduplicationId".equals(headerName) || "Sqs_Delay".equals(headerName) || "id".equals(headerName) || "timestamp".equals(headerName);
    }

    private MessageAttributeValue getBinaryMessageAttribute(ByteBuffer messageHeaderValue) {
        return (MessageAttributeValue)MessageAttributeValue.builder().dataType("Binary").binaryValue(SdkBytes.fromByteBuffer((ByteBuffer)messageHeaderValue)).build();
    }

    private MessageAttributeValue getContentTypeMessageAttribute(Object messageHeaderValue) {
        if (messageHeaderValue instanceof MimeType) {
            return this.getStringMessageAttribute(messageHeaderValue.toString());
        }
        if (messageHeaderValue instanceof String) {
            String stringValue = (String)messageHeaderValue;
            return this.getStringMessageAttribute(stringValue);
        }
        return this.getStringMessageAttribute("");
    }

    private MessageAttributeValue getStringMessageAttribute(String messageHeaderValue) {
        return (MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(messageHeaderValue).build();
    }

    private MessageAttributeValue getNumberMessageAttribute(Object messageHeaderValue) {
        Assert.isTrue((boolean)NumberUtils.STANDARD_NUMBER_TYPES.contains(messageHeaderValue.getClass()), (String)"Only standard number types are accepted as message header.");
        return (MessageAttributeValue)MessageAttributeValue.builder().dataType("Number." + messageHeaderValue.getClass().getName()).stringValue(messageHeaderValue.toString()).build();
    }

    @Override
    public MessageHeaders toHeaders(Message source) {
        logger.trace("Mapping headers for message {}", (Object)source.messageId());
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        accessor.copyHeadersIfAbsent(this.getMessageSystemAttributesAsHeaders(source));
        accessor.copyHeadersIfAbsent(this.getMessageAttributesAsHeaders(source));
        accessor.copyHeadersIfAbsent((Map)this.createDefaultHeaders(source));
        accessor.copyHeadersIfAbsent((Map)this.createAdditionalHeaders(source));
        MessageHeaders messageHeaders = accessor.toMessageHeaders();
        logger.trace("Mapped headers {} for message {}", (Object)messageHeaders, (Object)source.messageId());
        return new MessagingMessageHeaders((Map<String, Object>)messageHeaders, UUID.fromString(source.messageId()));
    }

    private MessageHeaders createAdditionalHeaders(Message source) {
        return this.additionalHeadersFunction.apply(source, new MessageHeaderAccessor());
    }

    private MessageHeaders createDefaultHeaders(Message source) {
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        accessor.setHeader("Sqs_ReceiptHandle", (Object)source.receiptHandle());
        accessor.setHeader("Sqs_SourceData", (Object)source);
        accessor.setHeader("Sqs_ReceivedAt", (Object)Instant.now());
        return accessor.toMessageHeaders();
    }

    private Map<String, String> getMessageAttributesAsHeaders(Message source) {
        return source.messageAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((MessageAttributeValue)entry.getValue()).stringValue()));
    }

    private Map<String, String> getMessageSystemAttributesAsHeaders(Message source) {
        return source.attributes().entrySet().stream().collect(Collectors.toMap(entry -> "Sqs_Msa_" + entry.getKey(), Map.Entry::getValue));
    }

    @Override
    public MessageHeaders createContextHeaders(Message source, MessageConversionContext context) {
        logger.trace("Creating context headers for message {}", (Object)source.messageId());
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        ConfigUtils.INSTANCE.acceptIfInstance(context, SqsMessageConversionContext.class, sqsContext -> this.addSqsContextHeaders(source, (SqsMessageConversionContext)sqsContext, accessor)).acceptIfInstance(context, SqsMessageConversionContext.class, smcc -> this.maybeAddAcknowledgementHeader((AcknowledgementAwareMessageConversionContext)smcc, accessor));
        MessageHeaders messageHeaders = accessor.toMessageHeaders();
        logger.trace("Context headers {} created for message {}", (Object)messageHeaders, (Object)source.messageId());
        return messageHeaders;
    }

    private void addSqsContextHeaders(Message source, SqsMessageConversionContext sqsContext, MessageHeaderAccessor accessor) {
        SqsAsyncClient sqsAsyncClient;
        QueueAttributes queueAttributes = sqsContext.getQueueAttributes();
        if (queueAttributes != null) {
            accessor.setHeader("Sqs_QueueName", (Object)queueAttributes.getQueueName());
            accessor.setHeader("Sqs_QueueUrl", (Object)queueAttributes.getQueueUrl());
            accessor.setHeader("Sqs_QueueAttributes", (Object)queueAttributes);
        }
        if ((sqsAsyncClient = sqsContext.getSqsAsyncClient()) != null && queueAttributes != null) {
            accessor.setHeader("Sqs_VisibilityTimeout", (Object)new QueueMessageVisibility(sqsAsyncClient, queueAttributes.getQueueUrl(), source.receiptHandle()));
        }
    }

    private void maybeAddAcknowledgementHeader(AcknowledgementAwareMessageConversionContext sqsContext, MessageHeaderAccessor accessor) {
        ConfigUtils.INSTANCE.acceptIfNotNull(sqsContext.getAcknowledgementCallback(), callback -> accessor.setHeader("AcknowledgementCallback", callback));
    }
}

