/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import io.awspring.cloud.sqs.ConfigUtils;
import io.awspring.cloud.sqs.listener.QueueAttributes;
import io.awspring.cloud.sqs.listener.QueueMessageVisibility;
import io.awspring.cloud.sqs.support.converter.AcknowledgementAwareMessageConversionContext;
import io.awspring.cloud.sqs.support.converter.ContextAwareHeaderMapper;
import io.awspring.cloud.sqs.support.converter.MessageConversionContext;
import io.awspring.cloud.sqs.support.converter.MessagingMessageHeaders;
import io.awspring.cloud.sqs.support.converter.SqsMessageConversionContext;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;

public class SqsHeaderMapper
implements ContextAwareHeaderMapper<Message> {
    private static final Logger logger = LoggerFactory.getLogger(SqsHeaderMapper.class);
    private BiFunction<Message, MessageHeaderAccessor, MessageHeaders> additionalHeadersFunction = (message, accessor) -> accessor.toMessageHeaders();

    public void setAdditionalHeadersFunction(BiFunction<Message, MessageHeaderAccessor, MessageHeaders> headerFunction) {
        Assert.notNull(headerFunction, (String)"headerFunction cannot be null");
        this.additionalHeadersFunction = headerFunction;
    }

    public void fromHeaders(MessageHeaders headers, Message target) {
    }

    public MessageHeaders toHeaders(Message source) {
        logger.trace("Mapping headers for message {}", (Object)source.messageId());
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        accessor.copyHeadersIfAbsent(this.getMessageSystemAttributesAsHeaders(source));
        accessor.copyHeadersIfAbsent(this.getMessageAttributesAsHeaders(source));
        accessor.copyHeadersIfAbsent((Map)this.createDefaultHeaders(source));
        accessor.copyHeadersIfAbsent((Map)this.createAdditionalHeaders(source, new MessageHeaderAccessor()));
        MessageHeaders messageHeaders = accessor.toMessageHeaders();
        logger.trace("Mapped headers {} for message {}", (Object)messageHeaders, (Object)source.messageId());
        return new MessagingMessageHeaders((Map<String, Object>)messageHeaders, UUID.fromString(source.messageId()));
    }

    private MessageHeaders createAdditionalHeaders(Message source, MessageHeaderAccessor accessor) {
        return this.additionalHeadersFunction.apply(source, accessor);
    }

    private MessageHeaders createDefaultHeaders(Message source) {
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        accessor.setHeader("Sqs_ReceiptHandle", (Object)source.receiptHandle());
        accessor.setHeader("Sqs_SourceData", (Object)source);
        accessor.setHeader("Sqs_ReceivedAt", (Object)Instant.now());
        return accessor.toMessageHeaders();
    }

    private Map<String, String> getMessageAttributesAsHeaders(Message source) {
        return source.messageAttributes().entrySet().stream().collect(Collectors.toMap(entry -> "Sqs_Ma_" + (String)entry.getKey(), entry -> ((MessageAttributeValue)entry.getValue()).stringValue()));
    }

    private Map<String, String> getMessageSystemAttributesAsHeaders(Message source) {
        return source.attributes().entrySet().stream().collect(Collectors.toMap(entry -> "Sqs_Msa_" + entry.getKey(), Map.Entry::getValue));
    }

    @Override
    public MessageHeaders createContextHeaders(Message source, MessageConversionContext context) {
        logger.trace("Creating context headers for message {}", (Object)source.messageId());
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        ConfigUtils.INSTANCE.acceptIfInstance(context, SqsMessageConversionContext.class, sqsContext -> this.addSqsContextHeaders(source, (SqsMessageConversionContext)sqsContext, accessor)).acceptIfInstance(context, SqsMessageConversionContext.class, smcc -> this.maybeAddAcknowledgementHeader((AcknowledgementAwareMessageConversionContext)smcc, accessor));
        MessageHeaders messageHeaders = accessor.toMessageHeaders();
        logger.trace("Context headers {} created for message {}", (Object)messageHeaders, (Object)source.messageId());
        return messageHeaders;
    }

    private void addSqsContextHeaders(Message source, SqsMessageConversionContext sqsContext, MessageHeaderAccessor accessor) {
        QueueAttributes queueAttributes = sqsContext.getQueueAttributes();
        SqsAsyncClient sqsAsyncClient = sqsContext.getSqsAsyncClient();
        accessor.setHeader("Sqs_QueueName", (Object)queueAttributes.getQueueName());
        accessor.setHeader("Sqs_QueueUrl", (Object)queueAttributes.getQueueUrl());
        accessor.setHeader("Sqs_QueueAttributes", (Object)queueAttributes);
        accessor.setHeader("Sqs_Visibility", (Object)new QueueMessageVisibility(sqsAsyncClient, queueAttributes.getQueueUrl(), source.receiptHandle()));
    }

    private void maybeAddAcknowledgementHeader(AcknowledgementAwareMessageConversionContext sqsContext, MessageHeaderAccessor accessor) {
        ConfigUtils.INSTANCE.acceptIfNotNull(sqsContext.getAcknowledgementCallback(), callback -> accessor.setHeader("Sqs_Acknowledgement", callback));
    }
}

