/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.acknowledgement;

import io.awspring.cloud.sqs.SqsException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.messaging.Message;

public class SqsAcknowledgementException
extends SqsException {
    private final Collection<Message<?>> failedAcknowledgementMessages;
    private final String queueUrl;

    public <T> SqsAcknowledgementException(String errorMessage, Collection<Message<T>> failedAcknowledgementMessages, String queueUrl, Throwable e) {
        super(errorMessage, e);
        this.queueUrl = queueUrl;
        this.failedAcknowledgementMessages = failedAcknowledgementMessages.stream().map(msg -> msg).collect(Collectors.toList());
    }

    public Collection<Message<?>> getFailedAcknowledgementMessages() {
        return this.failedAcknowledgementMessages;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }
}

