/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.config;

import io.awspring.cloud.sqs.config.AbstractEndpoint;
import java.time.Duration;
import java.util.Collection;
import org.springframework.lang.Nullable;

public class SqsEndpoint
extends AbstractEndpoint {
    private final Integer maxInflightMessagesPerQueue;
    private final Integer pollTimeoutSeconds;
    private final Integer messageVisibility;
    private final Integer maxMessagesPerPoll;

    protected SqsEndpoint(SqsEndpointBuilder builder) {
        super(builder.queueNames, builder.factoryName, builder.id);
        this.maxInflightMessagesPerQueue = builder.maxInflightMessagesPerQueue;
        this.pollTimeoutSeconds = builder.pollTimeoutSeconds;
        this.messageVisibility = builder.messageVisibility;
        this.maxMessagesPerPoll = builder.maxMessagesPerPoll;
    }

    public static SqsEndpointBuilder builder() {
        return new SqsEndpointBuilder();
    }

    @Nullable
    public Integer getMaxInflightMessagesPerQueue() {
        return this.maxInflightMessagesPerQueue;
    }

    @Nullable
    public Duration getPollTimeout() {
        return this.pollTimeoutSeconds != null ? Duration.ofSeconds(this.pollTimeoutSeconds.intValue()) : null;
    }

    @Nullable
    public Integer getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    @Nullable
    public Duration getMessageVisibility() {
        return this.messageVisibility != null ? Duration.ofSeconds(this.messageVisibility.intValue()) : null;
    }

    public static class SqsEndpointBuilder {
        private Collection<String> queueNames;
        private Integer maxInflightMessagesPerQueue;
        private Integer pollTimeoutSeconds;
        private String factoryName;
        private Integer messageVisibility;
        private String id;
        private Integer maxMessagesPerPoll;

        public SqsEndpointBuilder queueNames(Collection<String> queueNames) {
            this.queueNames = queueNames;
            return this;
        }

        public SqsEndpointBuilder factoryBeanName(String factoryName) {
            this.factoryName = factoryName;
            return this;
        }

        public SqsEndpointBuilder maxInflightMessagesPerQueue(Integer maxInflightMessagesPerQueue) {
            this.maxInflightMessagesPerQueue = maxInflightMessagesPerQueue;
            return this;
        }

        public SqsEndpointBuilder pollTimeoutSeconds(Integer pollTimeoutSeconds) {
            this.pollTimeoutSeconds = pollTimeoutSeconds;
            return this;
        }

        public SqsEndpointBuilder maxMessagesPerPoll(Integer maxMessagesPerPoll) {
            this.maxMessagesPerPoll = maxMessagesPerPoll;
            return this;
        }

        public SqsEndpointBuilder messageVisibility(Integer messageVisibility) {
            this.messageVisibility = messageVisibility;
            return this;
        }

        public SqsEndpointBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SqsEndpoint build() {
            return new SqsEndpoint(this);
        }
    }
}

