/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.messaging.Message;

public class MessageHeaderUtils {
    private MessageHeaderUtils() {
    }

    public static String getId(Message<?> message) {
        return MessageHeaderUtils.getHeader(message, "id", UUID.class).toString();
    }

    public static <T> String getId(Collection<Message<T>> messages) {
        return messages.stream().map(MessageHeaderUtils::getId).collect(Collectors.joining("; "));
    }

    public static <T> T getHeader(Message<?> message, String headerName, Class<T> classToCast) {
        return (T)Objects.requireNonNull(message.getHeaders().get((Object)headerName, classToCast), () -> String.format("Header %s not found in message %s", headerName, message));
    }

    public static <T, U> Collection<T> getHeader(Collection<Message<U>> messages, String headerName, Class<T> classToCast) {
        return messages.stream().map(msg -> MessageHeaderUtils.getHeader(msg, headerName, classToCast)).collect(Collectors.toList());
    }

    public static String getHeaderAsString(Message<?> message, String headerName) {
        return MessageHeaderUtils.getHeader(message, headerName, String.class);
    }
}

