/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import io.awspring.cloud.sqs.support.converter.ContextAwareHeaderMapper;
import io.awspring.cloud.sqs.support.converter.ContextAwareMessagingMessageConverter;
import io.awspring.cloud.sqs.support.converter.MessageConversionContext;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.HeaderMapper;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;

public abstract class AbstractMessagingMessageConverter<S>
implements ContextAwareMessagingMessageConverter<S> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessagingMessageConverter.class);
    private static final MessageConverter DEFAULT_MESSAGE_CONVERTER = new MappingJackson2MessageConverter();
    private String typeHeader = "Sqs_Ma_JavaType";
    private MessageConverter payloadMessageConverter = DEFAULT_MESSAGE_CONVERTER;
    private HeaderMapper<S> headerMapper = this.getDefaultHeaderMapper();
    private Function<Message<?>, Class<?>> payloadTypeMapper = this::defaultHeaderTypeMapping;

    public void setPayloadTypeMapper(Function<Message<?>, Class<?>> payloadTypeMapper) {
        Assert.notNull(payloadTypeMapper, (String)"payloadTypeMapper cannot be null");
        this.payloadTypeMapper = payloadTypeMapper;
    }

    public void setPayloadMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"messageConverter cannot be null");
        this.payloadMessageConverter = messageConverter;
    }

    public void setPayloadTypeHeader(String typeHeader) {
        Assert.notNull((Object)typeHeader, (String)"typeHeader cannot be null");
        this.typeHeader = "Sqs_Ma_" + typeHeader;
    }

    public void setHeaderMapper(HeaderMapper<S> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper cannot be null");
        this.headerMapper = headerMapper;
    }

    protected abstract HeaderMapper<S> getDefaultHeaderMapper();

    @Override
    public Message<?> toMessagingMessage(S message, @Nullable MessageConversionContext context) {
        MessageHeaders messageHeaders = this.createMessageHeaders(message, context);
        return MessageBuilder.createMessage((Object)this.convertPayload(message, messageHeaders), (MessageHeaders)messageHeaders);
    }

    private MessageHeaders createMessageHeaders(S message, MessageConversionContext context) {
        MessageHeaders messageHeaders = this.headerMapper.toHeaders(message);
        return context != null && this.headerMapper instanceof ContextAwareHeaderMapper ? this.addContextHeaders(message, context, messageHeaders) : messageHeaders;
    }

    private MessageHeaders addContextHeaders(S message, MessageConversionContext context, MessageHeaders messageHeaders) {
        MessageHeaders contextHeaders = this.getContextHeaders(message, context);
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        accessor.copyHeaders((Map)messageHeaders);
        accessor.copyHeaders((Map)contextHeaders);
        return accessor.getMessageHeaders();
    }

    private MessageHeaders getContextHeaders(S message, MessageConversionContext context) {
        return ((ContextAwareHeaderMapper)this.headerMapper).createContextHeaders(message, context);
    }

    private Object convertPayload(S message, MessageHeaders messageHeaders) {
        Message messagingMessage = MessageBuilder.createMessage((Object)this.getPayloadToConvert(message), (MessageHeaders)messageHeaders);
        Class<?> targetType = this.payloadTypeMapper.apply(messagingMessage);
        return targetType != null ? this.payloadMessageConverter.fromMessage(messagingMessage, targetType) : this.getPayloadToConvert(message);
    }

    protected abstract Object getPayloadToConvert(S var1);

    @Nullable
    private Class<?> defaultHeaderTypeMapping(Message<?> message) {
        String header = (String)message.getHeaders().get((Object)this.typeHeader, String.class);
        if (header == null) {
            return null;
        }
        try {
            return Class.forName(header);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No class found with name " + header);
        }
    }

    @Override
    public MessageConversionContext createMessageConversionContext() {
        return new MessageConversionContext(){};
    }

    @Override
    public S fromMessagingMessage(Message<?> message) {
        throw new UnsupportedOperationException("fromMessagingMessage not implemented");
    }
}

