/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.pipeline;

import io.awspring.cloud.sqs.listener.MessageProcessingContext;
import io.awspring.cloud.sqs.listener.pipeline.MessageProcessingConfiguration;
import io.awspring.cloud.sqs.listener.pipeline.MessageProcessingPipeline;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.messaging.Message;

public class MessageProcessingPipelineBuilder<T> {
    private final Function<MessageProcessingConfiguration<T>, MessageProcessingPipeline<T>> pipelineFactory;

    public MessageProcessingPipelineBuilder(Function<MessageProcessingConfiguration<T>, MessageProcessingPipeline<T>> pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    public static <T> MessageProcessingPipelineBuilder<T> first(Function<MessageProcessingConfiguration<T>, MessageProcessingPipeline<T>> pipelineFactory) {
        return new MessageProcessingPipelineBuilder<T>(pipelineFactory);
    }

    public MessageProcessingPipelineBuilder<T> then(Function<MessageProcessingConfiguration<T>, MessageProcessingPipeline<T>> pipelineFactory) {
        return new MessageProcessingPipelineBuilder<T>(configuration -> new ComposingMessagePipelineStage(this.pipelineFactory.apply((MessageProcessingConfiguration<MessageProcessingConfiguration>)configuration), (MessageProcessingPipeline)pipelineFactory.apply((MessageProcessingConfiguration<T>)configuration)));
    }

    public MessageProcessingPipelineBuilder<T> thenWrapWith(BiFunction<MessageProcessingConfiguration<T>, MessageProcessingPipeline<T>, MessageProcessingPipeline<T>> pipelineFactory) {
        return new MessageProcessingPipelineBuilder<T>(configuration -> (MessageProcessingPipeline)pipelineFactory.apply((MessageProcessingConfiguration<T>)configuration, this.pipelineFactory.apply((MessageProcessingConfiguration<MessageProcessingConfiguration>)configuration)));
    }

    public MessageProcessingPipelineBuilder<T> thenInTheFuture(Function<MessageProcessingConfiguration<T>, MessageProcessingPipeline<T>> pipelineFactory) {
        return new MessageProcessingPipelineBuilder<T>(configuration -> new FutureComposingMessagePipelineStage(this.pipelineFactory.apply((MessageProcessingConfiguration<MessageProcessingConfiguration>)configuration), (MessageProcessingPipeline)pipelineFactory.apply((MessageProcessingConfiguration<T>)configuration)));
    }

    public MessageProcessingPipeline<T> build(MessageProcessingConfiguration<T> configuration) {
        return this.pipelineFactory.apply(configuration);
    }

    private static class FutureComposingMessagePipelineStage<T>
    implements MessageProcessingPipeline<T> {
        private final MessageProcessingPipeline<T> first;
        private final MessageProcessingPipeline<T> second;

        private FutureComposingMessagePipelineStage(MessageProcessingPipeline<T> first, MessageProcessingPipeline<T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public CompletableFuture<Message<T>> process(Message<T> message, MessageProcessingContext<T> context) {
            return this.second.process(this.first.process(message, context), context);
        }

        @Override
        public CompletableFuture<Collection<Message<T>>> process(Collection<Message<T>> messages, MessageProcessingContext<T> context) {
            return this.second.processMany(this.first.process(messages, context), context);
        }
    }

    private static class ComposingMessagePipelineStage<T>
    implements MessageProcessingPipeline<T> {
        private final MessageProcessingPipeline<T> first;
        private final MessageProcessingPipeline<T> second;

        private ComposingMessagePipelineStage(MessageProcessingPipeline<T> first, MessageProcessingPipeline<T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public CompletableFuture<Message<T>> process(Message<T> message, MessageProcessingContext<T> context) {
            return this.first.process(message, context).thenCompose(msg -> this.second.process((Message<T>)msg, context));
        }

        @Override
        public CompletableFuture<Collection<Message<T>>> process(Collection<Message<T>> messages, MessageProcessingContext<T> context) {
            return this.first.process(messages, context).thenCompose(msgs -> this.second.process((Collection<Message<T>>)msgs, context));
        }
    }
}

