/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.core;

import io.awspring.cloud.sns.core.TopicArnResolver;
import org.springframework.util.Assert;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;

public class DefaultTopicArnResolver
implements TopicArnResolver {
    private final SnsClient snsClient;

    public DefaultTopicArnResolver(SnsClient snsClient) {
        this.snsClient = snsClient;
    }

    @Override
    public Arn resolveTopicArn(String topicName) {
        Assert.notNull((Object)topicName, (String)"topicName must not be null");
        if (topicName.toLowerCase().startsWith("arn:")) {
            return Arn.fromString((String)topicName);
        }
        return Arn.fromString((String)this.snsClient.createTopic((CreateTopicRequest)CreateTopicRequest.builder().name(topicName).build()).topicArn());
    }
}

