/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.core;

import io.awspring.cloud.sns.core.TopicArnResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.arns.Arn;

public class CachingTopicArnResolver
implements TopicArnResolver {
    private final TopicArnResolver delegate;
    private final Map<String, Arn> cache = new ConcurrentHashMap<String, Arn>();

    public CachingTopicArnResolver(TopicArnResolver topicArnResolver) {
        this.delegate = topicArnResolver;
    }

    @Override
    public Arn resolveTopicArn(String topicName) {
        if (topicName.toLowerCase().startsWith("arn:")) {
            return this.delegate.resolveTopicArn(topicName);
        }
        return this.cache.computeIfAbsent(topicName, this.delegate::resolveTopicArn);
    }
}

