/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.ses;

import io.awspring.cloud.ses.SimpleEmailServiceMailSender;
import jakarta.activation.FileTypeMap;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.lang.Nullable;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.model.RawMessage;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;
import software.amazon.awssdk.services.ses.model.SendRawEmailResponse;

public class SimpleEmailServiceJavaMailSender
extends SimpleEmailServiceMailSender
implements JavaMailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleEmailServiceJavaMailSender.class);
    private static final String SMART_MIME_MESSAGE_CLASS_NAME = "org.springframework.mail.javamail.SmartMimeMessage";
    private Properties javaMailProperties = new Properties();
    @Nullable
    private volatile Session session;
    @Nullable
    private String defaultEncoding;
    @Nullable
    private FileTypeMap defaultFileTypeMap;
    @Nullable
    private String fromArn;

    public SimpleEmailServiceJavaMailSender(SesClient sesClient) {
        this(sesClient, null);
    }

    public SimpleEmailServiceJavaMailSender(SesClient sesClient, @Nullable String sourceArn) {
        this(sesClient, sourceArn, null);
    }

    public SimpleEmailServiceJavaMailSender(SesClient sesClient, @Nullable String sourceArn, @Nullable String configurationSetName) {
        super(sesClient, sourceArn, configurationSetName);
    }

    public SimpleEmailServiceJavaMailSender(SesClient sesClient, @Nullable String sourceArn, @Nullable String configurationSetName, @Nullable String fromArn) {
        super(sesClient, sourceArn, configurationSetName);
        this.fromArn = fromArn;
    }

    protected Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        Assert.notNull((Object)javaMailProperties, (String)"javaMailProperties are required");
        this.javaMailProperties = javaMailProperties;
        this.session = null;
    }

    @Nullable
    protected Session getSession() {
        if (this.session == null) {
            this.session = Session.getInstance((Properties)this.getJavaMailProperties());
        }
        return this.session;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setDefaultFileTypeMap(FileTypeMap defaultFileTypeMap) {
        this.defaultFileTypeMap = defaultFileTypeMap;
    }

    public MimeMessage createMimeMessage() {
        if (ClassUtils.isPresent((String)SMART_MIME_MESSAGE_CLASS_NAME, (ClassLoader)ClassUtils.getDefaultClassLoader())) {
            Class smartMimeMessage = ClassUtils.resolveClassName((String)SMART_MIME_MESSAGE_CLASS_NAME, (ClassLoader)ClassUtils.getDefaultClassLoader());
            Constructor constructor = ClassUtils.getConstructorIfAvailable((Class)smartMimeMessage, (Class[])new Class[]{Session.class, String.class, FileTypeMap.class});
            if (constructor != null) {
                Object mimeMessage = BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{this.getSession(), this.defaultEncoding, this.defaultFileTypeMap});
                return (MimeMessage)mimeMessage;
            }
        }
        return new MimeMessage(this.getSession());
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        Assert.notNull((Object)contentStream, (String)"contentStream are required");
        try {
            return new MimeMessage(this.getSession(), contentStream);
        }
        catch (MessagingException e) {
            throw new MailParseException("Could not parse raw MIME content", (Throwable)e);
        }
    }

    public void send(MimeMessage ... mimeMessages) throws MailException {
        Assert.notNull((Object)mimeMessages, (String)"mimeMessages are required");
        HashMap<MimeMessage, Exception> failedMessages = new HashMap<MimeMessage, Exception>();
        for (MimeMessage mimeMessage : mimeMessages) {
            try {
                RawMessage rawMessage = this.createRawMessage(mimeMessage);
                SendRawEmailResponse sendRawEmailResponse = this.getEmailService().sendRawEmail((SendRawEmailRequest)SendRawEmailRequest.builder().sourceArn(this.getSourceArn()).fromArn(this.fromArn).configurationSetName(this.getConfigurationSetName()).rawMessage(rawMessage).build());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Message with id: {} successfully sent", (Object)sendRawEmailResponse.messageId());
                }
                mimeMessage.setHeader("Message-ID", sendRawEmailResponse.messageId());
            }
            catch (Exception e) {
                failedMessages.put(mimeMessage, e);
            }
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }

    private RawMessage createRawMessage(MimeMessage mimeMessage) {
        ByteArrayOutputStream out;
        try {
            out = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)out);
        }
        catch (IOException e) {
            throw new MailPreparationException((Throwable)e);
        }
        catch (MessagingException e) {
            throw new MailParseException((Throwable)e);
        }
        return (RawMessage)RawMessage.builder().data(SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(out.toByteArray()))).build();
    }
}

