/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.secretsmanager;

import io.awspring.cloud.core.config.AwsPropertySource;
import io.awspring.cloud.core.support.JacksonPresent;
import io.awspring.cloud.secretsmanager.Jackson2SecretValueReader;
import io.awspring.cloud.secretsmanager.JacksonSecretValueReader;
import io.awspring.cloud.secretsmanager.SecretParseException;
import io.awspring.cloud.secretsmanager.SecretValueReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

public class SecretsManagerPropertySource
extends AwsPropertySource<SecretsManagerPropertySource, SecretsManagerClient> {
    private static Log LOG = LogFactory.getLog(SecretsManagerPropertySource.class);
    private static final String PREFIX_PART = "?prefix=";
    private final SecretValueReader secretValueReader;
    private final String context;
    private final String secretId;
    private final @Nullable String prefix;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public SecretsManagerPropertySource(String context, SecretsManagerClient smClient) {
        super("aws-secretsmanager:" + context, (Object)smClient);
        Assert.notNull((Object)context, (String)"context is required");
        this.context = context;
        this.secretId = SecretsManagerPropertySource.resolveSecretId(context);
        this.prefix = SecretsManagerPropertySource.resolvePrefix(context);
        if (JacksonPresent.isJackson3Present()) {
            this.secretValueReader = new JacksonSecretValueReader();
        } else if (JacksonPresent.isJackson2Present()) {
            this.secretValueReader = new Jackson2SecretValueReader();
        } else {
            throw new IllegalStateException("SecretsManagerPropertySource requires a Jackson 2 or Jackson 3 library on the classpath");
        }
    }

    public void init() {
        this.readSecretValue((GetSecretValueRequest)GetSecretValueRequest.builder().secretId(this.secretId).build());
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    public @Nullable Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void readSecretValue(GetSecretValueRequest secretValueRequest) {
        GetSecretValueResponse secretValueResponse = ((SecretsManagerClient)this.source).getSecretValue(secretValueRequest);
        if (secretValueResponse.secretString() != null) {
            try {
                Map<String, Object> secretMap = this.secretValueReader.readSecretValue(secretValueResponse.secretString());
                for (Map.Entry<String, Object> secretEntry : secretMap.entrySet()) {
                    LOG.debug((Object)("Populating property retrieved from AWS Secrets Manager: " + secretEntry.getKey()));
                    String propertyKey = this.prefix != null ? this.prefix + secretEntry.getKey() : secretEntry.getKey();
                    this.properties.put(propertyKey, secretEntry.getValue());
                }
            }
            catch (SecretParseException e) {
                String[] parts = secretValueResponse.name().split("/");
                String secretName = parts[parts.length - 1];
                LOG.debug((Object)("Populating property retrieved from AWS Secrets Manager: " + secretName));
                String propertyKey = this.prefix != null ? this.prefix + secretName : secretName;
                this.properties.put(propertyKey, secretValueResponse.secretString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            String[] parts = secretValueResponse.name().split("/");
            String secretName = parts[parts.length - 1];
            LOG.debug((Object)("Populating property retrieved from AWS Secrets Manager: " + secretName));
            String propertyKey = this.prefix != null ? this.prefix + secretName : secretName;
            this.properties.put(propertyKey, secretValueResponse.secretBinary().asByteArray());
        }
    }

    public SecretsManagerPropertySource copy() {
        return new SecretsManagerPropertySource(this.context, (SecretsManagerClient)this.source);
    }

    @Nullable String getPrefix() {
        return this.prefix;
    }

    String getContext() {
        return this.context;
    }

    String getSecretId() {
        return this.secretId;
    }

    private static @Nullable String resolvePrefix(String context) {
        int prefixIndex = context.indexOf(PREFIX_PART);
        if (prefixIndex != -1) {
            return context.substring(prefixIndex + PREFIX_PART.length());
        }
        return null;
    }

    private static String resolveSecretId(String context) {
        int prefixIndex = context.indexOf(PREFIX_PART);
        if (prefixIndex != -1) {
            return context.substring(0, prefixIndex);
        }
        return context;
    }
}

